/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;

public class InvertedRsNandLatch
extends AbstractIC {
    public InvertedRsNandLatch(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Inverted RS NAND latch";
    }

    @Override
    public String getSignTitle() {
        return "INV RS NAND LAT";
    }

    @Override
    public void trigger(ChipState chip) {
        boolean set = chip.getInput(0);
        boolean reset = chip.getInput(1);
        if (!set && !reset) {
            chip.setOutput(0, true);
        } else if (set && !reset) {
            chip.setOutput(0, false);
        } else if (!set && reset) {
            chip.setOutput(0, true);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Set", "Reset", "Nothing", "Output"};
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new InvertedRsNandLatch(this.getServer(), sign, this);
        }
    }
}

