/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;

public class HalfSubtractor
extends AbstractIC {
    public HalfSubtractor(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Half Subtractor";
    }

    @Override
    public String getSignTitle() {
        return "HALF SUBTRACTOR";
    }

    @Override
    public void trigger(ChipState chip) {
        boolean b = chip.getInput(1);
        boolean c = chip.getInput(2);
        boolean sum = b ^ c;
        boolean borrow = !b & c;
        chip.setOutput(0, sum);
        chip.setOutput(1, borrow);
        chip.setOutput(2, borrow);
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Nothing", "Bit to subtract from (minuend)", "Bit to subtract (subtrahend)", "Difference", "Borrow", "Borrow (Same as Output 2)"};
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new HalfSubtractor(this.getServer(), sign, this);
        }
    }
}

