/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;

public class HalfAdder
extends AbstractIC {
    public HalfAdder(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Half Adder";
    }

    @Override
    public String getSignTitle() {
        return "HALF ADDER";
    }

    @Override
    public void trigger(ChipState chip) {
        boolean b = chip.getInput(1);
        boolean c = chip.getInput(2);
        boolean sum = b ^ c;
        boolean carry = b & c;
        chip.setOutput(0, sum);
        chip.setOutput(1, carry);
        chip.setOutput(2, carry);
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Nothing", "First bit to add", "Second bit to add", "Sum", "Carry", "Carry (Same as Output 2)"};
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new HalfAdder(this.getServer(), sign, this);
        }
    }
}

