/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;

public class FullAdder
extends AbstractIC {
    public FullAdder(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Full Adder";
    }

    @Override
    public String getSignTitle() {
        return "FULL ADDER";
    }

    @Override
    public void trigger(ChipState chip) {
        boolean a = chip.getInput(0);
        boolean b = chip.getInput(1);
        boolean c = chip.getInput(2);
        boolean sum = a ^ b ^ c;
        boolean carry = a & b | (a ^ b) & c;
        chip.setOutput(0, sum);
        chip.setOutput(1, carry);
        chip.setOutput(2, carry);
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"First bit to add", "Second bit to add", "Third bit to add (carry in)", "Sum", "Carry out", "Carry out (Same as Output 2)"};
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new FullAdder(this.getServer(), sign, this);
        }
    }
}

