/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;

public class EdgeTriggerDFlipFlop
extends AbstractIC {
    public EdgeTriggerDFlipFlop(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Edge triggered D flip-flop";
    }

    @Override
    public String getSignTitle() {
        return "EDGE-D";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(2)) {
            chip.setOutput(0, false);
        } else if (chip.getInput(1) && chip.isTriggered(1)) {
            chip.setOutput(0, chip.getInput(0));
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Carries over to Output 1", "Sets Output 1 to Input 1", "Sets Output 1 to Low.", "Carried Value"};
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new EdgeTriggerDFlipFlop(this.getServer(), sign, this);
        }
    }
}

