/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;

public class Delayer
extends AbstractIC {
    private BukkitTask taskId;
    private long delay = 1L;
    private boolean tickDelay;
    private boolean stayOnLow;

    public Delayer(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public void load() {
        this.delay = Long.parseLong(this.getLine(2));
        this.tickDelay = Boolean.parseBoolean(this.getLine(3).split(":")[0]);
        if (this.getLine(3).contains(":")) {
            this.stayOnLow = Boolean.parseBoolean(this.getLine(3).split(":")[1]);
        }
    }

    @Override
    public String getTitle() {
        return "Delayer";
    }

    @Override
    public String getSignTitle() {
        return "DELAYER";
    }

    @Override
    public void trigger(ChipState chip) {
        long tdelay = this.delay * 20L;
        if (this.tickDelay) {
            tdelay = this.delay;
        }
        if (chip.getInput(0)) {
            this.taskId = Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> chip.setOutput(0, true), tdelay);
        } else {
            if (this.taskId != null && !this.stayOnLow) {
                this.taskId.cancel();
            }
            chip.setOutput(0, false);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new Delayer(this.getServer(), sign, this);
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            try {
                Integer.parseInt(PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)));
            }
            catch (Exception ignored) {
                throw new ICVerificationException("The third line needs to be a number.");
            }
        }

        @Override
        public String getShortDescription() {
            return "Delays signal by X seconds (or ticks if set).";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "Delayed Output"};
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"seconds", "true to use ticks:true to continue on low"};
        }
    }
}

