/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;

public class CombinationLock
extends AbstractIC {
    public CombinationLock(Server server, BukkitChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Combination Lock";
    }

    @Override
    public String getSignTitle() {
        return "COMBINATION LOCK";
    }

    @Override
    public void trigger(ChipState state) {
        try {
            char[] data = this.getLine(2).toCharArray();
            if (state.getInput(0) == (data[1] == 'X') && state.getInput(1) == (data[2] == 'X') && state.getInput(2) == (data[0] == 'X')) {
                state.setOutput(0, true);
                return;
            }
            state.setOutput(0, false);
        }
        catch (Exception e) {
            state.setOutput(0, false);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new CombinationLock(this.getServer(), sign, this);
        }

        @Override
        public void verify(BukkitChangedSign sign) throws ICVerificationException {
            if (sign.getLine(2) == null && PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)).isEmpty()) {
                throw new ICVerificationException("Line three needs to be a combination");
            }
        }

        @Override
        public String getShortDescription() {
            return "Checks combination on sign against inputs.";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Combination Bit 1", "Combination Bit 2", "Combination Bit 3", "High on Correct Combination"};
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Combination. X = On, O = Off (XOX)", null};
        }
    }
}

