/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import net.kyori.adventure.text.Component;
import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;

public class ClockDivider
extends AbstractIC {
    public ClockDivider(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Clock Divider";
    }

    @Override
    public String getSignTitle() {
        return "CLOCK DIVIDER";
    }

    @Override
    public void trigger(ChipState chip) {
        int reset = 0;
        int count = 0;
        try {
            reset = Integer.parseInt(this.getLine(2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            count = Integer.parseInt(this.getLine(3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        reset = Math.min(100000, Math.max(1, reset));
        if (++count < reset) {
            this.getSign().setLine(3, (Component)Component.text((int)count));
            return;
        }
        chip.setOutput(0, !chip.getOutput(0));
        count = 0;
        this.getSign().setLine(3, (Component)Component.text((int)count));
        this.getSign().update(false);
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new ClockDivider(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Clock that toggles output when reset.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"ticks required", "current ticks"};
        }
    }
}

