/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.gates.logic;

import org.bukkit.Server;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractICFactory;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.gates.logic.SimpleAnyInputLogicGate;

public class AndGate
extends SimpleAnyInputLogicGate {
    public AndGate(Server server, BukkitChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "And Gate";
    }

    @Override
    public String getSignTitle() {
        return "AND";
    }

    @Override
    protected boolean getResult(int wires, int on) {
        return wires > 0 && on == wires;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(BukkitChangedSign sign) {
            return new AndGate(this.getServer(), sign, this);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Input", "Input", "Input", "High if all inputs are high, and there is atleast 1 input"};
        }

        @Override
        public String getShortDescription() {
            return "Outputs high if all inputs are high.";
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"{| class='wiki-table' style='float: right; clear: both'", "! A !! B !! C !! Output", "|-", "| 0 || 0 || 0 || 0", "|-", "| 0 || 0 || 1 || 0", "|-", "| 0 || 1 || 1 || 0", "|-", "| 0 || 1 || 0 || 0", "|-", "| 1 || 1 || 0 || 0", "|-", "| 1 || 0 || 0 || 0", "|-", "| 1 || 0 || 1 || 0", "|-", "| 1 || 1 || 1 || 1", "|}", "", "The '''MC3002''' outputs a high if and only if all three inputs are high.", "As of Craftbook alpha 3 or equivalent, any combination of inputs is valid and all 3 are not needed.", "", "Equivalent [[../Perlstone/]] script: <code>ABC&&r</code>"};
        }
    }
}

