/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.families;

import com.sk89q.worldedit.util.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractChipState;
import org.enginehub.craftbook.mechanics.ic.AbstractICFamily;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.util.SignUtil;

public class FamilySISO
extends AbstractICFamily {
    @Override
    public ChipState detect(Location source, BukkitChangedSign sign) {
        return new ChipStateSISO(source, sign);
    }

    @Override
    public ChipState detectSelfTriggered(Location source, BukkitChangedSign sign) {
        return new ChipStateSISO(source, sign, true);
    }

    @Override
    public String getName() {
        return "SISO";
    }

    public static class ChipStateSISO
    extends AbstractChipState {
        public ChipStateSISO(Location source, BukkitChangedSign sign) {
            super(source, sign, false);
        }

        public ChipStateSISO(Location source, BukkitChangedSign sign, boolean selfTriggered) {
            super(source, sign, selfTriggered);
        }

        @Override
        protected Block getBlock(int pin) {
            switch (pin) {
                case 0: {
                    return SignUtil.getFrontBlock(this.sign.getBlock());
                }
                case 1: {
                    BlockFace face = SignUtil.getBack(this.sign.getBlock());
                    return this.sign.getBlock().getRelative(face).getRelative(face);
                }
            }
            return null;
        }

        @Override
        public boolean getInput(int inputIndex) {
            return this.get(inputIndex);
        }

        @Override
        public boolean getOutput(int outputIndex) {
            return this.get(outputIndex + 1);
        }

        @Override
        public void setOutput(int outputIndex, boolean value) {
            this.set(outputIndex + 1, value);
        }

        @Override
        public int getInputCount() {
            return 1;
        }

        @Override
        public int getOutputCount() {
            return 1;
        }
    }
}

