/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic.families;

import com.sk89q.worldedit.util.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.AbstractChipState;
import org.enginehub.craftbook.mechanics.ic.AbstractICFamily;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.util.ICUtil;
import org.enginehub.craftbook.util.SignUtil;

public class Family3I5O
extends AbstractICFamily {
    @Override
    public ChipState detect(Location source, BukkitChangedSign sign) {
        return new ChipState3I5O(source, sign);
    }

    @Override
    public ChipState detectSelfTriggered(Location source, BukkitChangedSign sign) {
        return new ChipState3I5O(source, sign, true);
    }

    @Override
    public String getName() {
        return "3I5O";
    }

    public static class ChipState3I5O
    extends AbstractChipState {
        public ChipState3I5O(Location source, BukkitChangedSign sign) {
            super(source, sign, false);
        }

        public ChipState3I5O(Location source, BukkitChangedSign sign, boolean selfTriggered) {
            super(source, sign, selfTriggered);
        }

        @Override
        protected Block getBlock(int pin) {
            BlockFace fback = SignUtil.getBack(this.sign.getBlock());
            Block backBlock = SignUtil.getBackBlock(this.sign.getBlock()).getRelative(fback);
            Block farBlock = backBlock.getRelative(fback);
            switch (pin) {
                case 0: {
                    return SignUtil.getFrontBlock(this.sign.getBlock());
                }
                case 1: {
                    return SignUtil.getLeftBlock(this.sign.getBlock());
                }
                case 2: {
                    return SignUtil.getRightBlock(this.sign.getBlock());
                }
                case 3: {
                    return farBlock.getRelative(fback);
                }
                case 4: {
                    return farBlock.getRelative(SignUtil.getCounterClockWise(fback));
                }
                case 5: {
                    return farBlock.getRelative(SignUtil.getClockWise(fback));
                }
                case 6: {
                    return backBlock.getRelative(SignUtil.getCounterClockWise(fback));
                }
                case 7: {
                    return backBlock.getRelative(SignUtil.getClockWise(fback));
                }
            }
            return null;
        }

        @Override
        public boolean getInput(int inputIndex) {
            return this.get(inputIndex);
        }

        @Override
        public boolean getOutput(int outputIndex) {
            return this.get(outputIndex + 3);
        }

        @Override
        public void setOutput(int outputIndex, boolean value) {
            this.set(outputIndex + 3, value);
        }

        @Override
        public void set(int pin, boolean value) {
            Block block = this.getBlock(pin);
            if (block != null) {
                if (pin == 3 || pin == 4 || pin == 5) {
                    ICUtil.setState(block, value, this.icBlock.getRelative(SignUtil.getBack(this.sign.getBlock()), 2));
                } else {
                    ICUtil.setState(block, value, this.icBlock.getRelative(SignUtil.getBack(this.sign.getBlock())));
                }
            }
        }

        @Override
        public int getInputCount() {
            return 3;
        }

        @Override
        public int getOutputCount() {
            return 5;
        }
    }
}

