/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.platform.Actor;
import io.papermc.paper.math.Position;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SelfTriggerPingEvent;
import org.enginehub.craftbook.bukkit.events.SelfTriggerThinkEvent;
import org.enginehub.craftbook.bukkit.events.SelfTriggerUnregisterEvent;
import org.enginehub.craftbook.bukkit.events.SignClickEvent;
import org.enginehub.craftbook.bukkit.events.SourcedBlockRedstoneEvent;
import org.enginehub.craftbook.bukkit.st.BukkitSelfTriggerManager;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicCommandRegistrar;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICCommands;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICFamily;
import org.enginehub.craftbook.mechanics.ic.ICManager;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.PipeInputIC;
import org.enginehub.craftbook.mechanics.ic.RegisteredICFactory;
import org.enginehub.craftbook.mechanics.ic.RestrictedIC;
import org.enginehub.craftbook.mechanics.ic.SelfTriggeredIC;
import org.enginehub.craftbook.mechanics.pipe.PipePutEvent;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.ICUtil;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;

public class ICMechanic
extends AbstractCraftBookMechanic
implements Listener {
    protected final ICManager manager = new ICManager();
    public static ICMechanic instance;
    public boolean cache;
    public boolean shortHand;
    public double maxRange;
    public List<String> disabledICs;
    public boolean keepLoaded;
    public ICUtil.LocationCheckType defaultCoordinates;
    public boolean savePersistentData;
    public boolean usePercussionMidi;
    public boolean breakOnError;
    public boolean disableSelfTriggered;

    public ICMechanic(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
        instance = this;
    }

    @Override
    public void enable() {
        ICManager.inst().enable();
        MechanicCommandRegistrar registrar = CraftBookPlugin.inst().getCommandManager().getMechanicRegistrar();
        registrar.registerTopLevelWithSubCommands("ic", List.of("ics"), "CraftBook Integrated Circuit Commands", ICCommands::register);
    }

    @Override
    public void disable() {
        this.manager.disable();
        MechanicCommandRegistrar registrar = CraftBookPlugin.inst().getCommandManager().getMechanicRegistrar();
        registrar.unregisterTopLevel("ic");
        registrar.unregisterTopLevel("ics");
    }

    public Object[] setupIC(Block block, boolean create) {
        IC ic;
        if (!SignUtil.isWallSign(block)) {
            return null;
        }
        BukkitChangedSign sign = BukkitChangedSign.create(block, Side.FRONT);
        String line1 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(1));
        Matcher matcher = RegexUtil.IC_PATTERN.matcher(line1);
        if (!matcher.matches()) {
            return null;
        }
        String prefix = matcher.group(2);
        if (prefix.equalsIgnoreCase("MCA")) {
            sign.setLine(1, (Component)Component.text((String)(line1.toLowerCase(Locale.ENGLISH).replace("mca", "mc") + "a").toUpperCase(Locale.ENGLISH)));
            sign.update(false);
            return this.setupIC(block, create);
        }
        if (line1.toLowerCase(Locale.ENGLISH).startsWith("[mc0")) {
            if (line1.equalsIgnoreCase("[mc0420]")) {
                sign.setLine(1, (Component)Component.text((String)"[MC1421]S"));
            } else if (line1.equalsIgnoreCase("[mc0421]")) {
                sign.setLine(1, (Component)Component.text((String)"[MC1422]S"));
            } else {
                sign.setLine(1, (Component)Component.text((String)(line1.toLowerCase(Locale.ENGLISH).replace("mc0", "mc1") + "s").toUpperCase(Locale.ENGLISH)));
            }
            sign.update(false);
            return this.setupIC(block, create);
        }
        if (line1.toLowerCase(Locale.ENGLISH).startsWith("[mcz")) {
            sign.setLine(1, (Component)Component.text((String)(line1.toLowerCase(Locale.ENGLISH).replace("mcz", "mcx") + "s").toUpperCase(Locale.ENGLISH)));
            sign.update(false);
            return this.setupIC(block, create);
        }
        if (!ICManager.hasCustomPrefix(prefix)) {
            return null;
        }
        String id = matcher.group(1);
        if (this.disabledICs.contains(id.toLowerCase()) || this.disabledICs.contains(id)) {
            return null;
        }
        RegisteredICFactory registration = this.manager.get(id);
        if (registration == null) {
            CraftBook.LOGGER.warn("\"" + String.valueOf(sign.getLine(1)) + "\" should be an IC ID, but no IC registered under that ID could be found.");
            block.breakNaturally();
            return null;
        }
        String line0 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(0));
        if (ICManager.isCachedIC(block.getLocation())) {
            ic = ICManager.getCachedIC(block.getLocation());
            if (ic.getSign().updateSign(sign)) {
                ICManager.removeCachedIC(block.getLocation());
                ic = registration.getFactory().create(sign);
                if (!line0.equals(ic.getSignTitle()) && !line0.startsWith("=")) {
                    sign.setLine(0, (Component)Component.text((String)ic.getSignTitle()));
                    sign.update(false);
                }
                ic.load();
                ICManager.addCachedIC(block.getLocation(), ic);
            }
        } else if (create) {
            ic = registration.getFactory().create(sign);
            if (!line0.equals(ic.getSignTitle()) && !line0.startsWith("=")) {
                sign.setLine(0, (Component)Component.text((String)ic.getSignTitle()));
                sign.update(false);
            }
            ic.load();
            ICManager.addCachedIC(block.getLocation(), ic);
        } else {
            return null;
        }
        String suffix = "";
        String[] str = RegexUtil.RIGHT_BRACKET_PATTERN.split(line1);
        if (str.length > 1) {
            suffix = str[1];
        }
        ICFamily family = registration.getFamilies()[0];
        if (suffix != null && !suffix.isEmpty()) {
            for (ICFamily f : registration.getFamilies()) {
                if (!f.getSuffix().equalsIgnoreCase(suffix)) continue;
                family = f;
                break;
            }
        }
        if (ic instanceof SelfTriggeredIC && (line1.trim().toUpperCase(Locale.ENGLISH).endsWith("S") || ((SelfTriggeredIC)ic).isAlwaysST())) {
            if (this.disableSelfTriggered) {
                return null;
            }
            ((BukkitSelfTriggerManager)CraftBook.getInstance().getPlatform().getSelfTriggerManager()).registerSelfTrigger(block.getLocation());
        }
        Object[] rets = new Object[]{id, family, ic};
        return rets;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Object[] icData = this.setupIC(event.getBlock(), true);
        if (icData == null) {
            return;
        }
        Block block = event.getBlock();
        if (event.getNewCurrent() == event.getOldCurrent()) {
            return;
        }
        if (SignUtil.isWallSign(block)) {
            Block source = event.getSource();
            if (SignUtil.getBackBlock(block).equals((Object)source) || block.equals((Object)source)) {
                return;
            }
            Runnable runnable = () -> {
                block5: {
                    if (!SignUtil.isWallSign(block)) {
                        return;
                    }
                    try {
                        Sign bukkitSign = (Sign)event.getBlock().getState(false);
                        Side side = bukkitSign.getInteractableSideFor((Position)event.getSource().getLocation());
                        BukkitChangedSign sign = BukkitChangedSign.create(block, side, bukkitSign.getSide(side).lines().toArray(new Component[0]), null);
                        ChipState chipState = ((ICFamily)icData[1]).detect(BukkitAdapter.adapt((Location)source.getLocation()), sign);
                        int cnt = 0;
                        for (int i = 0; i < chipState.getInputCount(); ++i) {
                            if (!chipState.isTriggered(i)) continue;
                            ++cnt;
                        }
                        if (cnt > 0) {
                            ((IC)icData[2]).trigger(chipState);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        if (ex.getMessage().contains("Null BukkitChangedSign found")) break block5;
                        throw ex;
                    }
                }
            };
            Bukkit.getServer().getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), runnable, 2L);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        Object[] icData;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (ICManager.isCachedIC(event.getClickedBlock().getLocation()) && event.getPlayer().isSneaking()) {
            ICManager.getCachedIC(event.getClickedBlock().getLocation()).unload();
            ICManager.removeCachedIC(event.getClickedBlock().getLocation());
        }
        if ((icData = this.setupIC(event.getClickedBlock(), true)) == null) {
            return;
        }
        ((IC)icData[2]).onRightClick(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onThinkPing(SelfTriggerPingEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        this.setupIC(event.getBlock(), true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onThinkUnregister(SelfTriggerUnregisterEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Object[] icData = this.setupIC(event.getBlock(), false);
        if (icData != null) {
            if (event.getReason() == SelfTriggerUnregisterEvent.UnregisterReason.ERROR && this.breakOnError) {
                ((IC)icData[2]).unload();
                event.getBlock().breakNaturally();
                return;
            }
            if (this.keepLoaded) {
                event.setCancelled(true);
                return;
            }
            ((IC)icData[2]).unload();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onThink(SelfTriggerThinkEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Object[] icData = this.setupIC(event.getBlock(), true);
        if (icData != null && icData[2] instanceof SelfTriggeredIC) {
            event.setHandled(true);
            ChipState chipState = ((ICFamily)icData[1]).detectSelfTriggered(BukkitAdapter.adapt((Location)event.getBlock().getLocation()), ((IC)icData[2]).getSign());
            ((SelfTriggeredIC)icData[2]).think(chipState);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Object[] icData = this.setupIC(event.getBlock(), false);
        if (icData == null) {
            return;
        }
        ((BukkitSelfTriggerManager)CraftBook.getInstance().getPlatform().getSelfTriggerManager()).unregisterSelfTrigger(event.getBlock().getLocation(), SelfTriggerUnregisterEvent.UnregisterReason.BREAK);
        ICManager.removeCachedIC(event.getBlock().getLocation());
        ((IC)icData[2]).onICBreak(event);
        if (!event.isCancelled()) {
            ((IC)icData[2]).unload();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPipePut(PipePutEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Object[] icData = this.setupIC(event.getPuttingBlock(), true);
        if (icData == null) {
            return;
        }
        if (icData[2] instanceof PipeInputIC) {
            ((PipeInputIC)icData[2]).onPipeTransfer(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        this.initializeIC(event.getBlock(), CraftBookPlugin.inst().wrapPlayer(event.getPlayer()), event, false);
    }

    public void initializeIC(Block block, CraftBookPlayer player, SignChangeEvent event, boolean shortHand) {
        boolean matches = true;
        Matcher matcher = RegexUtil.IC_PATTERN.matcher(event.getLine(1));
        if (!matcher.matches()) {
            matches = false;
        }
        try {
            if (!ICManager.hasCustomPrefix(matcher.group(2))) {
                matches = false;
            }
        }
        catch (Exception e) {
            matches = false;
        }
        if (matches) {
            RegisteredICFactory registration;
            try {
                String prefix = matcher.group(2);
                if (prefix.equalsIgnoreCase("MCA")) {
                    event.setLine(1, (event.getLine(1).toLowerCase(Locale.ENGLISH).replace("mca", "mc") + "a").toUpperCase(Locale.ENGLISH));
                    this.initializeIC(block, player, event, shortHand);
                    return;
                }
                if (event.getLine(1).toLowerCase(Locale.ENGLISH).startsWith("[mc0")) {
                    if (event.getLine(1).equalsIgnoreCase("[mc0420]")) {
                        event.setLine(1, "[MC1421]S");
                    } else if (event.getLine(1).equalsIgnoreCase("[mc0421]")) {
                        event.setLine(1, "[MC1422]S");
                    } else {
                        event.setLine(1, (event.getLine(1).toLowerCase(Locale.ENGLISH).replace("mc0", "mc1") + "s").toUpperCase(Locale.ENGLISH));
                    }
                    this.initializeIC(block, player, event, shortHand);
                    return;
                }
                if (event.getLine(1).toLowerCase(Locale.ENGLISH).startsWith("[mcz")) {
                    event.setLine(1, (event.getLine(1).toLowerCase(Locale.ENGLISH).replace("mcz", "mcx") + "s").toUpperCase(Locale.ENGLISH));
                    this.initializeIC(block, player, event, shortHand);
                    return;
                }
            }
            catch (Exception prefix) {
                // empty catch block
            }
            String id = matcher.group(1);
            String[] str = RegexUtil.RIGHT_BRACKET_PATTERN.split(event.getLine(1));
            String suffix = str.length > 1 ? str[1] : "";
            if (!SignUtil.isWallSign(block)) {
                player.printError("Only wall signs are used for ICs.");
                SignUtil.cancelSignChange(event);
                return;
            }
            if (ICManager.isCachedIC(block.getLocation())) {
                CraftBookPlugin.logDebugMessage("Existing IC found at selected location!", "ic-create");
                ICManager.getCachedIC(block.getLocation()).unload();
                ICManager.removeCachedIC(block.getLocation());
            }
            if ((registration = this.manager.get(id)) == null) {
                player.printError("Unknown IC detected: " + id);
                SignUtil.cancelSignChange(event);
                return;
            }
            ICFactory factory = registration.getFactory();
            try {
                ICMechanic.checkPermissions((Actor)player, factory, registration.getId().toLowerCase(Locale.ENGLISH));
            }
            catch (ICVerificationException e) {
                player.printError(e.getMessage());
                SignUtil.cancelSignChange(event);
                return;
            }
            Bukkit.getServer().getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> {
                BukkitChangedSign sign = BukkitChangedSign.create(event.getBlock(), event.getSide(), event.lines().toArray(new Component[0]), null);
                ICUtil.parseSignFlags(player, sign);
                try {
                    factory.verify(sign);
                    factory.checkPlayer(sign, player);
                }
                catch (ICVerificationException e) {
                    player.printError(e.getMessage());
                    event.getBlock().breakNaturally();
                    return;
                }
                IC ic = registration.getFactory().create(sign);
                ic.load();
                sign.setLine(1, (Component)Component.text((String)("[" + registration.getId() + "]" + suffix)));
                if (!shortHand) {
                    sign.setLine(0, (Component)Component.text((String)ic.getSignTitle()));
                }
                sign.update(false);
                if (ic instanceof SelfTriggeredIC && (event.getLine(1).trim().toUpperCase(Locale.ENGLISH).endsWith("S") || ((SelfTriggeredIC)ic).isAlwaysST())) {
                    if (this.disableSelfTriggered) {
                        player.printError("Self-triggered ICs are disabled!");
                        return;
                    }
                    ((BukkitSelfTriggerManager)CraftBook.getInstance().getPlatform().getSelfTriggerManager()).registerSelfTrigger(block.getLocation());
                }
                player.print(player.translate("mech.ic.create") + " " + registration.getId() + ": " + ic.getTitle() + ".");
            });
            return;
        }
        if (shortHand && event.getLine(0).startsWith("=")) {
            String id = event.getLine(0).substring(1);
            boolean st = id.toLowerCase(Locale.ENGLISH).endsWith(" st");
            String shortId = this.manager.longRegistered.get((id = id.toLowerCase(Locale.ENGLISH).replace(" st", "")).toLowerCase(Locale.ENGLISH));
            if (shortId == null) {
                player.printError("Warning: Unknown IC");
                return;
            }
            if (!SignUtil.isWallSign(block)) {
                player.printError("Only wall signs are used for ICs.");
                SignUtil.cancelSignChange(event);
                return;
            }
            event.setLine(1, "[" + shortId + "]" + (st ? "S" : ""));
            this.initializeIC(block, player, event, true);
            return;
        }
    }

    public static boolean checkPermissionsBoolean(Actor player, ICFactory factory, String id) {
        try {
            ICMechanic.checkPermissions(player, factory, id);
        }
        catch (ICVerificationException e) {
            return false;
        }
        return true;
    }

    public static void checkPermissions(Actor player, ICFactory factory, String id) throws ICVerificationException {
        if (player.hasPermission("craftbook.ic." + id.toLowerCase(Locale.ENGLISH))) {
            return;
        }
        if (player.hasPermission("craftbook.ic." + factory.getClass().getPackage().getName() + "." + id.toLowerCase(Locale.ENGLISH))) {
            return;
        }
        if (factory instanceof RestrictedIC ? ICMechanic.hasRestrictedPermissions(player, factory, id) : ICMechanic.hasSafePermissions(player, factory, id)) {
            return;
        }
        throw new ICVerificationException("You don't have permission to use " + id.toLowerCase(Locale.ENGLISH) + ".");
    }

    public static boolean hasRestrictedPermissions(Actor player, ICFactory factory, String id) {
        return player.hasPermission("craftbook.ic.restricted." + id.toLowerCase(Locale.ENGLISH));
    }

    public static boolean hasSafePermissions(Actor player, ICFactory factory, String id) {
        return player.hasPermission("craftbook.ic.safe." + id.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("cache", "Saves many CPU cycles with a VERY small cost to memory (Highly Recommended)");
        this.cache = config.getBoolean("cache", true);
        config.setComment("max-radius", "The max radius IC's with a radius setting can use. (WILL cause lag at higher values)");
        this.maxRange = config.getDouble("max-radius", 10.0);
        config.setComment("allow-short-hand", "Allows the usage of IC Shorthand, which is an easier way to create ICs.");
        this.shortHand = config.getBoolean("allow-short-hand", true);
        config.setComment("keep-loaded", "Keep any chunk with an ST IC in it loaded.");
        this.keepLoaded = config.getBoolean("keep-loaded", false);
        config.setComment("disallowed-ics", "A list of IC's which are never loaded. They will not work or show up in /ic list.");
        this.disabledICs = config.getStringList("disallowed-ics", new ArrayList());
        config.setComment("default-coordinate-system", "The default coordinate system for ICs. This changes the way IC offsets work. From RELATIVE, OFFSET and ABSOLUTE.");
        this.defaultCoordinates = ICUtil.LocationCheckType.getTypeFromName(config.getString("default-coordinate-system", "RELATIVE"));
        config.setComment("save-persistent-data", "Saves extra data to the CraftBook folder that allows some ICs to work better on server restart.");
        this.savePersistentData = config.getBoolean("save-persistent-data", true);
        config.setComment("midi-use-percussion", "Plays the MIDI percussion channel when using a MIDI playing IC. Note: This may sound horrible on some songs.");
        this.usePercussionMidi = config.getBoolean("midi-use-percussion", false);
        config.setComment("break-on-error", "Break the IC sign when an error occurs from that specific IC.");
        this.breakOnError = config.getBoolean("break-on-error", false);
        config.setComment("disable-self-triggered", "Disable creation and checking of self-triggered ICs.");
        this.disableSelfTriggered = config.getBoolean("disable-self-triggered", false);
    }
}

