/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic;

import com.sk89q.worldedit.extension.platform.Actor;
import java.util.Locale;
import org.bukkit.ChatColor;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICManager;
import org.enginehub.craftbook.mechanics.ic.ICMechanic;
import org.enginehub.craftbook.mechanics.ic.RegisteredICFactory;

public class ICDocsParser {
    private ICDocsParser() {
    }

    public static void generateICDocs(Actor player, String id) {
        RegisteredICFactory ric = ICManager.inst().registered.get(id.toLowerCase(Locale.ENGLISH));
        if (ric == null) {
            try {
                ric = ICManager.inst().registered.get(ICManager.inst().getSearchID(id));
                if (ric == null) {
                    player.printError("Invalid IC!");
                    return;
                }
            }
            catch (Exception e) {
                player.printError("Invalid IC!");
                return;
            }
        }
        try {
            IC ic = ric.getFactory().create(null);
            player.print(" ");
            player.print(String.valueOf(ChatColor.BLUE) + ic.getTitle() + " (" + ric.getId() + ") Documentation");
            if (ICMechanic.instance.shortHand && ric.getShorthand() != null) {
                player.print("Shorthand: =" + ric.getShorthand());
            }
            player.print("Desc: " + ric.getFactory().getShortDescription());
            if (ric.getFactory().getLineHelp()[0] != null) {
                player.print("Line 3: " + ICDocsParser.parseLine(ric.getFactory().getLineHelp()[0]));
            } else {
                player.printDebug("Line 3: Blank.");
            }
            if (ric.getFactory().getLineHelp()[1] != null) {
                player.print("Line 4: " + ICDocsParser.parseLine(ric.getFactory().getLineHelp()[1]));
            } else {
                player.printDebug("Line 4: Blank.");
            }
            player.print(String.valueOf(ChatColor.AQUA) + "Wiki: " + CraftBook.getDocsDomain() + "/" + ric.getId().toUpperCase(Locale.ENGLISH));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String parseLine(String line) {
        if (((String)line).contains("+o")) {
            line = String.valueOf(ChatColor.GRAY) + (String)line + " (Optional)";
        }
        line = ((String)line).replace("{", String.valueOf(ChatColor.GRAY));
        line = ((String)line).replace("}", String.valueOf(ChatColor.YELLOW));
        return ((String)line).replace("+o", "");
    }
}

