/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic;

import com.sk89q.util.yaml.YAMLProcessor;
import java.io.IOException;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanics.ic.ConfigurableIC;
import org.enginehub.craftbook.mechanics.ic.ICManager;
import org.enginehub.craftbook.mechanics.ic.RegisteredICFactory;

public class ICConfiguration {
    public final YAMLProcessor config;

    public ICConfiguration(YAMLProcessor config) {
        this.config = config;
    }

    public void load() {
        try {
            this.config.load();
        }
        catch (IOException e) {
            CraftBook.LOGGER.error("Error loading CraftBook IC configuration", (Throwable)e);
        }
        for (RegisteredICFactory factory : ICManager.inst().getICList()) {
            if (!(factory.getFactory() instanceof ConfigurableIC)) continue;
            ((ConfigurableIC)((Object)factory.getFactory())).addConfiguration(this.config, "ics." + factory.getId() + ".");
        }
        this.config.save();
    }
}

