/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.craftbook.mechanics.ic.ICCommands;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;

public final class ICCommandsRegistration
implements CommandRegistration<ICCommands> {
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private CommandManager commandManager;
    private ICCommands containerInstance;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument icPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"piston.argument.ic"), (Component)TextComponent.of((String)"The IC ID")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"The page")).withRequiredArg().argNamed(TranslatableComponent.of((String)"piston.argument.page")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument termPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"piston.argument.term"), (Component)TextComponent.of((String)"The search term")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final ArgAcceptingCommandFlag pagePart2 = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Page number")).withRequiredArg().argNamed(TranslatableComponent.of((String)"piston.argument.page")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();

    private ICCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static ICCommandsRegistration builder() {
        return new ICCommandsRegistration();
    }

    public ICCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public ICCommandsRegistration containerInstance(ICCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    public ICCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("info", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"doc", (Object)"docs", (Object)"help", (Object)"man"));
            b.description((Component)TextComponent.of((String)"Documentation on CraftBook IC's"));
            b.parts((Collection)ImmutableList.of((Object)this.icPart));
            b.action(this::cmd$info);
        });
        this.commandManager.register("list", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"List available IC's"));
            b.parts((Collection)ImmutableList.of((Object)this.pagePart));
            b.action(this::cmd$list);
        });
        this.commandManager.register("search", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Search available IC's with names"));
            b.parts((Collection)ImmutableList.of((Object)this.termPart, (Object)this.pagePart));
            b.action(this::cmd$search);
        });
        this.commandManager.register("midis", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"midilist"));
            b.description((Component)TextComponent.of((String)"List MIDI's available for Melody IC"));
            b.parts((Collection)ImmutableList.of((Object)this.pagePart2));
            b.action(this::cmd$midis);
        });
        this.commandManager.register("fireworks", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"List Fireworks available for PFD IC"));
            b.parts((Collection)ImmutableList.of((Object)this.pagePart2));
            b.action(this::cmd$fireworks);
        });
    }

    private int cmd$info(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ICCommands.class, (String)"info", (Class[])new Class[]{Actor.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.info(this.extract$actor(parameters), this.extract$ic(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$list(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ICCommands.class, (String)"listCmd", (Class[])new Class[]{Actor.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.listCmd(this.extract$actor(parameters), this.extract$page(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$search(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ICCommands.class, (String)"searchCmd", (Class[])new Class[]{Actor.class, String.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.searchCmd(this.extract$actor(parameters), this.extract$term(parameters), this.extract$page(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$midis(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ICCommands.class, (String)"midis", (Class[])new Class[]{Actor.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.midis(this.extract$actor(parameters), this.extract$page2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$fireworks(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ICCommands.class, (String)"fireworks", (Class[])new Class[]{Actor.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.fireworks(this.extract$actor(parameters), this.extract$page2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private String extract$ic(CommandParameters parameters) {
        return (String)this.icPart.value(parameters).asSingle(string_Key);
    }

    private int extract$page(CommandParameters parameters) {
        return (Integer)this.pagePart.value(parameters).asSingle(integer_Key);
    }

    private String extract$term(CommandParameters parameters) {
        return (String)this.termPart.value(parameters).asSingle(string_Key);
    }

    private int extract$page2(CommandParameters parameters) {
        return (Integer)this.pagePart2.value(parameters).asSingle(integer_Key);
    }
}

