/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.bukkit.Server;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.mechanics.ic.ChipState;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.mechanics.ic.ICMechanic;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.ic.PersistentDataIC;

public abstract class AbstractICFactory
implements ICFactory {
    private final Server server;

    public AbstractICFactory(Server server) {
        this.server = server;
    }

    protected Server getServer() {
        return this.server;
    }

    @Override
    public void verify(BukkitChangedSign sign) throws ICVerificationException {
    }

    @Override
    public void checkPlayer(BukkitChangedSign sign, CraftBookPlayer player) throws ICVerificationException {
    }

    @Override
    public String getShortDescription() {
        return "No Description.";
    }

    @Override
    public String[] getLongDescription() {
        return new String[]{"Missing Description"};
    }

    @Override
    public String[] getLineHelp() {
        return new String[]{null, null};
    }

    @Override
    public String[] getPinDescription(ChipState state) {
        return new String[state.getInputCount() + state.getOutputCount()];
    }

    @Override
    public void load() {
        if (this instanceof PersistentDataIC && ICMechanic.instance.savePersistentData) {
            try {
                if (((PersistentDataIC)((Object)this)).getStorageFile().exists()) {
                    ((PersistentDataIC)((Object)this)).loadPersistentData(new DataInputStream(new FileInputStream(((PersistentDataIC)((Object)this)).getStorageFile())));
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                CraftBook.LOGGER.error("An invalid ic save file was found!", (Throwable)e);
            }
        }
    }

    @Override
    public void unload() {
    }
}

