/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.ic;

import com.sk89q.worldedit.extension.platform.Actor;
import java.util.Objects;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICDocsParser;
import org.enginehub.craftbook.mechanics.ic.ICFactory;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;

public abstract class AbstractIC
implements IC {
    private final Server server;
    private final BukkitChangedSign sign;
    private final ICFactory factory;

    public AbstractIC(Server server, BukkitChangedSign sign, ICFactory factory) {
        this.factory = factory;
        this.server = server;
        this.sign = sign;
    }

    protected Server getServer() {
        return this.server;
    }

    @Override
    public BukkitChangedSign getSign() {
        return this.sign;
    }

    public Location getLocation() {
        return this.getSign().getBlock().getLocation();
    }

    public Block getBackBlock() {
        return SignUtil.getBackBlock(this.sign.getBlock());
    }

    public String getLine(int line) {
        return PlainTextComponentSerializer.plainText().serialize(this.sign.getLine(line));
    }

    public String getRawLine(int line) {
        return PlainTextComponentSerializer.plainText().serialize(this.sign.getRawLine(line));
    }

    public ICFactory getFactory() {
        return this.factory;
    }

    public CraftBookPlugin getPlugin() {
        return CraftBookPlugin.inst();
    }

    @Override
    public void onRightClick(Player p) {
        if (p.isSneaking()) {
            ICDocsParser.generateICDocs((Actor)CraftBookPlugin.inst().wrapPlayer(p), RegexUtil.RIGHT_BRACKET_PATTERN.split(RegexUtil.LEFT_BRACKET_PATTERN.split(this.getLine(1))[1])[0]);
        }
    }

    @Override
    public void onICBreak(BlockBreakEvent event) {
    }

    @Override
    public void unload() {
        this.sign.update(false);
    }

    @Override
    public void load() {
    }

    public boolean equals(Object o) {
        return o instanceof AbstractIC && this.getSignTitle().equalsIgnoreCase(((AbstractIC)o).getSignTitle()) && this.getTitle().equalsIgnoreCase(((AbstractIC)o).getTitle()) && this.sign.equals(((AbstractIC)o).sign);
    }

    public int hashCode() {
        return Objects.hash(this.sign, this.getSignTitle(), this.getTitle());
    }
}

