/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.drops;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.block.Biome;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.mechanics.drops.DropItemStack;
import org.enginehub.craftbook.mechanics.drops.rewards.DropReward;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.TernaryState;

public abstract class CustomDropDefinition {
    public static final DropReward[] EMPTY_DROP_REWARDS = new DropReward[0];
    private DropItemStack[] drops;
    private DropReward[] extraRewards;
    private String name;
    private String permissionNode;
    private boolean append;
    private TernaryState silkTouch;
    private List<String> regions;
    private List<ItemStack> items;
    private List<Biome> biomes;

    public CustomDropDefinition(String name, List<DropItemStack> drops, List<DropReward> extraRewards, TernaryState silkTouch) {
        this.drops = drops.toArray(new DropItemStack[drops.size()]);
        if (extraRewards != null) {
            this.extraRewards = extraRewards.toArray(new DropReward[extraRewards.size()]);
        }
        this.name = name;
        this.silkTouch = silkTouch;
    }

    public void setPermissionNode(String permissionNode) {
        this.permissionNode = permissionNode;
    }

    public String getPermissionNode() {
        return this.permissionNode;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public boolean getAppend() {
        return this.append;
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public void setRegions(List<String> regions) {
        this.regions = regions;
        if (this.regions.isEmpty()) {
            this.regions = null;
        }
    }

    public List<Biome> getBiomes() {
        return this.biomes;
    }

    public void setBiomes(List<Biome> biomes) {
        this.biomes = biomes;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(List<ItemStack> items) {
        this.items = items;
        if (this.items.isEmpty()) {
            this.items = null;
        }
    }

    public DropReward[] getRewards() {
        if (this.extraRewards == null) {
            this.extraRewards = EMPTY_DROP_REWARDS;
        }
        return this.extraRewards;
    }

    public DropItemStack[] getDrops() {
        return this.drops;
    }

    public ItemStack[] getRandomDrops() {
        ArrayList<ItemStack> ndrops = new ArrayList<ItemStack>();
        for (DropItemStack drop : this.drops) {
            if (drop.getChance() < ThreadLocalRandom.current().nextDouble() * 100.0) continue;
            ItemStack stack = drop.getStack().clone();
            if (drop.getMaximum() >= 0 && drop.getMinimum() >= 0) {
                int amount = drop.getMinimum() + ThreadLocalRandom.current().nextInt(drop.getMaximum() - drop.getMinimum() + 1);
                if (amount <= 0) continue;
                stack.setAmount(amount);
            }
            if (!ItemUtil.isStackValid(stack)) continue;
            ndrops.add(stack);
        }
        return ndrops.toArray(new ItemStack[ndrops.size()]);
    }

    public TernaryState getSilkTouch() {
        return this.silkTouch;
    }

    public String getName() {
        return this.name;
    }
}

