/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.crafting;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.mechanics.crafting.RecipeCommands;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;

public final class RecipeCommandsRegistration
implements CommandRegistration<RecipeCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private static final Key<CraftBookPlayer> craftBookPlayer_Key = Key.of(CraftBookPlayer.class);
    private CommandManager commandManager;
    private RecipeCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument recipePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"piston.argument.recipe"), (Component)TextComponent.of((String)"The recipe to remove")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument namePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"piston.argument.name"), (Component)TextComponent.of((String)"The recipe to remove")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument recipeTypePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"piston.argument.recipeType"), (Component)TextComponent.of((String)"The recipe type")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final ArgAcceptingCommandFlag permissionNodePart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"The permission node to assign")).withRequiredArg().argNamed(TranslatableComponent.of((String)"piston.argument.permissionNode")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();

    private RecipeCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static RecipeCommandsRegistration builder() {
        return new RecipeCommandsRegistration();
    }

    public RecipeCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public RecipeCommandsRegistration containerInstance(RecipeCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    public RecipeCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public RecipeCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("remove", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"delete"));
            b.description((Component)TextComponent.of((String)"Delete a recipe"));
            b.parts((Collection)ImmutableList.of((Object)this.recipePart));
            b.action(this::cmd$remove);
            Method commandMethod = RegistrationUtil.getCommandMethod(RecipeCommands.class, (String)"remove", (Class[])new Class[]{Actor.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("save", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"add"));
            b.description((Component)TextComponent.of((String)"Saves the current recipe"));
            b.parts((Collection)ImmutableList.of((Object)this.namePart, (Object)this.recipeTypePart, (Object)this.permissionNodePart));
            b.action(this::cmd$save);
            Method commandMethod = RegistrationUtil.getCommandMethod(RecipeCommands.class, (String)"saveRecipe", (Class[])new Class[]{CraftBookPlayer.class, String.class, String.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$remove(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RecipeCommands.class, (String)"remove", (Class[])new Class[]{Actor.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.remove(this.extract$actor(parameters), this.extract$recipe(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$save(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RecipeCommands.class, (String)"saveRecipe", (Class[])new Class[]{CraftBookPlayer.class, String.class, String.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.saveRecipe(this.extract$player(parameters), this.extract$name(parameters), this.extract$recipeType(parameters), this.extract$permissionNode(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private String extract$recipe(CommandParameters parameters) {
        return (String)this.recipePart.value(parameters).asSingle(string_Key);
    }

    private CraftBookPlayer extract$player(CommandParameters parameters) {
        return (CraftBookPlayer)RegistrationUtil.requireOptional(craftBookPlayer_Key, (String)"player", (Optional)parameters.injectedValue(craftBookPlayer_Key));
    }

    private String extract$name(CommandParameters parameters) {
        return (String)this.namePart.value(parameters).asSingle(string_Key);
    }

    private String extract$recipeType(CommandParameters parameters) {
        return (String)this.recipeTypePart.value(parameters).asSingle(string_Key);
    }

    private String extract$permissionNode(CommandParameters parameters) {
        return (String)this.permissionNodePart.value(parameters).asSingle(string_Key);
    }
}

