/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.crafting;

import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitCraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanics.crafting.CraftingItemStack;
import org.enginehub.craftbook.mechanics.crafting.CustomCrafting;
import org.enginehub.craftbook.mechanics.crafting.RecipeCommandsRegistration;
import org.enginehub.craftbook.mechanics.crafting.RecipeManager;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.gen.CommandRegistration;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class RecipeCommands {
    private final CraftBookPlugin plugin = CraftBookPlugin.inst();

    public static void register(CommandManager commandManager, CommandRegistrationHandler registration) {
        registration.register(commandManager, (CommandRegistration)RecipeCommandsRegistration.builder(), (Object)new RecipeCommands());
    }

    @Command(name="remove", aliases={"delete"}, desc="Delete a recipe")
    @CommandPermissions(value={"craftbook.mech.recipes.remove"})
    public void remove(Actor actor, @Arg(desc="The recipe to remove") String recipe) {
        if (RecipeManager.INSTANCE.removeRecipe(recipe)) {
            actor.print("Recipe removed successfully! This will be in effect after a restart!");
            RecipeManager.INSTANCE.save();
        } else {
            actor.printError("Recipe doesn't exist!");
        }
    }

    @Command(name="save", aliases={"add"}, desc="Saves the current recipe")
    @CommandPermissions(value={"craftbook.mech.recipes.add"})
    public void saveRecipe(CraftBookPlayer player, @Arg(desc="The recipe to remove") String name, @Arg(desc="The recipe type") String recipeType, @ArgFlag(name=112, desc="The permission node to assign") String permissionNode) {
        Player bukkitPlayer = ((BukkitCraftBookPlayer)player).getPlayer();
        RecipeManager.RecipeType type = RecipeManager.RecipeType.getTypeFromName(recipeType);
        HashMap<String, Object> advancedData = new HashMap<String, Object>();
        if (permissionNode != null) {
            advancedData.put("permission-node", permissionNode);
        }
        ItemStack[] slots = new ItemStack[]{bukkitPlayer.getInventory().getItem(9), bukkitPlayer.getInventory().getItem(10), bukkitPlayer.getInventory().getItem(11), bukkitPlayer.getInventory().getItem(18), bukkitPlayer.getInventory().getItem(19), bukkitPlayer.getInventory().getItem(20), bukkitPlayer.getInventory().getItem(27), bukkitPlayer.getInventory().getItem(28), bukkitPlayer.getInventory().getItem(29)};
        if (type == RecipeManager.RecipeType.SHAPED) {
            ItemStack stack;
            int slot;
            LinkedHashMap<CraftingItemStack, Character> items = new LinkedHashMap<CraftingItemStack, Character>();
            int furtherestX = -1;
            int furtherestY = -1;
            for (slot = 0; slot < 3; ++slot) {
                stack = slots[slot];
                if (!ItemUtil.isStackValid(stack)) continue;
                furtherestY = 0;
                if (furtherestX >= slot) continue;
                furtherestX = slot;
            }
            for (slot = 3; slot < 6; ++slot) {
                stack = slots[slot];
                if (!ItemUtil.isStackValid(stack)) continue;
                furtherestY = 1;
                if (furtherestX >= slot - 3) continue;
                furtherestX = slot - 3;
            }
            for (slot = 6; slot < 9; ++slot) {
                stack = slots[slot];
                if (!ItemUtil.isStackValid(stack)) continue;
                furtherestY = 2;
                if (furtherestX >= slot - 6) continue;
                furtherestX = slot - 6;
            }
            if (furtherestX > 2) {
                furtherestX = 2;
            }
            String[] shape = new String[furtherestY + 1];
            Character[] characters = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i')};
            int curChar = 0;
            for (int y = 0; y < furtherestY + 1; ++y) {
                for (int x = 0; x < furtherestX + 1; ++x) {
                    String c = " ";
                    CraftingItemStack stack2 = new CraftingItemStack(slots[x + y * 3]);
                    if (ItemUtil.isStackValid(stack2.getItemStack())) {
                        boolean found = false;
                        for (Map.Entry st : items.entrySet()) {
                            if (!((CraftingItemStack)st.getKey()).isSameType(stack2)) continue;
                            c = ((Character)st.getValue()).toString();
                            found = true;
                            break;
                        }
                        if (!found) {
                            items.put(stack2, characters[curChar]);
                            c = characters[curChar].toString();
                            ++curChar;
                        }
                    }
                    shape[y] = x == 0 ? c : shape[y] + c;
                }
            }
            List<CraftingItemStack> results = this.getResults((Inventory)bukkitPlayer.getInventory());
            if (results.size() > 1) {
                advancedData.put("extra-results", results.subList(1, results.size()));
            } else if (results.isEmpty()) {
                player.printError("Results are required to create a recipe!");
                return;
            }
            try {
                RecipeManager recipeManager = RecipeManager.INSTANCE;
                Objects.requireNonNull(recipeManager);
                RecipeManager.Recipe recipe = new RecipeManager.Recipe(recipeManager, name, type, items, Arrays.asList(shape), results.get(0), advancedData);
                RecipeManager.INSTANCE.addRecipe(recipe);
                if (CustomCrafting.INSTANCE == null) {
                    player.printError("You do not have CustomCrafting enabled, or Java has bugged and unloaded it (Did you use /reload?)!");
                    return;
                }
                CustomCrafting.INSTANCE.addRecipe(recipe);
                player.print("Successfully added a new " + type.name() + " recipe!");
            }
            catch (Exception e) {
                player.printError("Error adding recipe! See console for more details!");
                e.printStackTrace();
            }
        } else if (type == RecipeManager.RecipeType.SHAPELESS || type == RecipeManager.RecipeType.FURNACE) {
            ArrayList<CraftingItemStack> ingredients = new ArrayList<CraftingItemStack>();
            for (ItemStack slot : slots) {
                if (!ItemUtil.isStackValid(slot)) continue;
                CraftingItemStack stack = new CraftingItemStack(slot.clone());
                boolean used = false;
                for (CraftingItemStack compare : ingredients) {
                    if (!compare.isSameType(stack)) continue;
                    ingredients.set(ingredients.indexOf(compare), compare.add(stack));
                    used = true;
                    break;
                }
                if (used) continue;
                ingredients.add(stack);
            }
            List<CraftingItemStack> results = this.getResults((Inventory)bukkitPlayer.getInventory());
            if (results.size() > 1) {
                advancedData.put("extra-results", results.subList(1, results.size()));
            } else if (results.isEmpty()) {
                player.printError("Results are required to create a recipe!");
                return;
            }
            try {
                RecipeManager recipeManager = RecipeManager.INSTANCE;
                Objects.requireNonNull(recipeManager);
                RecipeManager.Recipe recipe = new RecipeManager.Recipe(recipeManager, name, type, ingredients, results.get(0), advancedData);
                RecipeManager.INSTANCE.addRecipe(recipe);
                CustomCrafting.INSTANCE.addRecipe(recipe);
                player.print("Successfully added a new " + type.name() + " recipe!");
            }
            catch (Exception e) {
                player.printError("Error adding recipe! See console for more details!");
                e.printStackTrace();
            }
        }
    }

    public List<CraftingItemStack> getResults(Inventory inv) {
        ItemStack slot;
        ArrayList<CraftingItemStack> results = new ArrayList<CraftingItemStack>();
        for (int i = 21; i < 27 && ItemUtil.isStackValid(slot = inv.getItem(i)); ++i) {
            results.add(new CraftingItemStack(slot));
        }
        return results;
    }
}

