/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.crafting;

import com.google.common.base.MoreObjects;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.entity.Player;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicCommandRegistrar;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.crafting.CraftingItemStack;
import org.enginehub.craftbook.mechanics.crafting.InvalidCraftingException;
import org.enginehub.craftbook.mechanics.crafting.RecipeCommands;
import org.enginehub.craftbook.mechanics.crafting.RecipeManager;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.ParsingUtil;

public class CustomCrafting
extends AbstractCraftBookMechanic
implements Listener {
    public static CustomCrafting INSTANCE;
    private RecipeManager manager;
    public static final Set<String> registeredNames;
    private static final Map<Recipe, RecipeManager.Recipe> advancedRecipes;

    public CustomCrafting(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() {
        INSTANCE = this;
        MechanicCommandRegistrar registrar = CraftBookPlugin.inst().getCommandManager().getMechanicRegistrar();
        registrar.registerTopLevelWithSubCommands("recp", List.of("recps"), "CraftBook Custom Crafting Commands", RecipeCommands::register);
        CraftBookPlugin.inst().createDefaultConfiguration("crafting-recipes.yml");
        this.manager = new RecipeManager(new YAMLProcessor(new File(CraftBookPlugin.inst().getDataFolder(), "crafting-recipes.yml"), true, YAMLFormat.EXTENDED));
        Collection<RecipeManager.Recipe> recipeCollection = this.manager.getRecipes();
        int recipes = 0;
        for (RecipeManager.Recipe r : recipeCollection) {
            if (!this.addRecipe(r)) continue;
            ++recipes;
        }
        CraftBook.LOGGER.info("Registered " + recipes + " custom recipes!");
    }

    @Override
    public void disable() {
        advancedRecipes.clear();
        this.manager.disable();
        this.manager = null;
        MechanicCommandRegistrar registrar = CraftBookPlugin.inst().getCommandManager().getMechanicRegistrar();
        registrar.unregisterTopLevel("recp");
        registrar.unregisterTopLevel("recps");
        INSTANCE = null;
    }

    public boolean addRecipe(RecipeManager.Recipe r) {
        if (registeredNames.contains(r.getId())) {
            CraftBook.LOGGER.warn("A recipe with name " + r.getId() + " has already been registered by CraftBook. Due to a limitation in Bukkit-derivitive servers, this can't be registered again without a restart.");
            return false;
        }
        try {
            ShapelessRecipe sh;
            if (r.getType() == RecipeManager.RecipeType.SHAPELESS) {
                sh = new ShapelessRecipe(new NamespacedKey((Plugin)CraftBookPlugin.inst(), r.getId()), r.getResult().getItemStack());
                for (CraftingItemStack is : r.getIngredients()) {
                    sh.addIngredient(is.getItemStack().getAmount(), is.getItemStack().getType());
                }
            } else if (r.getType() == RecipeManager.RecipeType.SHAPED) {
                sh = new ShapedRecipe(new NamespacedKey((Plugin)CraftBookPlugin.inst(), r.getId()), r.getResult().getItemStack());
                ((ShapedRecipe)sh).shape(r.getShape());
                for (Map.Entry<CraftingItemStack, Character> is : r.getShapedIngredients().entrySet()) {
                    ((ShapedRecipe)sh).setIngredient(is.getValue().charValue(), is.getKey().getItemStack().getType());
                }
            } else if (r.getType() == RecipeManager.RecipeType.FURNACE) {
                if (r.getIngredients().isEmpty()) {
                    CraftBookPlugin.inst().getLogger().warning("Recipe " + r.getId() + " is missing ingredients");
                    return false;
                }
                sh = new FurnaceRecipe(new NamespacedKey((Plugin)CraftBookPlugin.inst(), r.getId()), r.getResult().getItemStack(), r.getIngredients().get(0).getItemStack().getType(), r.getExperience(), r.getCookTime());
                for (CraftingItemStack is : r.getIngredients()) {
                    ((FurnaceRecipe)sh).setInput(is.getItemStack().getType());
                }
            } else {
                return false;
            }
            CraftBookPlugin.inst().getServer().addRecipe((Recipe)sh);
            registeredNames.add(r.getId());
            if (r.hasAdvancedData()) {
                advancedRecipes.put((Recipe)sh, r);
                CraftBookPlugin.logDebugMessage("Adding a new recipe with advanced data!", "advanced-data.init");
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            CraftBook.LOGGER.error("Corrupt or invalid recipe!");
            CraftBook.LOGGER.error("Please either delete custom-crafting.yml, or fix the issues with your recipes file!");
            e.printStackTrace();
        }
        catch (Exception e) {
            CraftBook.LOGGER.error("Failed to load recipe! Is it incorrectly written?", (Throwable)e);
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void prepareCraft(PrepareItemCraftEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        ItemStack bits = null;
        org.bukkit.entity.Player p = null;
        CraftBookPlayer lp = null;
        try {
            p = (org.bukkit.entity.Player)event.getViewers().get(0);
            lp = CraftBookPlugin.inst().wrapPlayer(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CraftBookPlugin.logDebugMessage("Pre-Crafting has been initiated!", "advanced-data");
        try {
            boolean hasFailed = false;
            block5: for (Map.Entry<Recipe, RecipeManager.Recipe> recipeRecipeEntry : advancedRecipes.entrySet()) {
                CraftingItemStack[] tests2;
                if (!ItemUtil.areRecipesIdentical(recipeRecipeEntry.getKey(), event.getRecipe())) continue;
                RecipeManager.Recipe recipe = recipeRecipeEntry.getValue();
                ItemStack[] tests = ((CraftingInventory)event.getView().getTopInventory()).getMatrix();
                if (recipe.getType() == RecipeManager.RecipeType.SHAPED) {
                    ArrayList<CraftingItemStack> stacks = new ArrayList<CraftingItemStack>();
                    for (String string : recipe.getShape()) {
                        for (char c : string.toCharArray()) {
                            for (Map.Entry<CraftingItemStack, Character> entry : recipe.getShapedIngredients().entrySet()) {
                                if (entry.getValue().charValue() != c) continue;
                                stacks.add(entry.getKey());
                            }
                        }
                    }
                    tests2 = stacks.toArray(new CraftingItemStack[0]);
                } else {
                    tests2 = recipe.getIngredients().toArray(new CraftingItemStack[0]);
                }
                ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>(Arrays.asList(tests));
                leftovers.removeAll(Collections.singleton(null));
                for (String string : tests) {
                    if (!ItemUtil.isStackValid((ItemStack)string)) {
                        if (string == null) continue;
                        CraftBookPlugin.logDebugMessage("Invalid item in recipe: " + MoreObjects.toStringHelper((Object)string).toString(), "advanced-data");
                        continue;
                    }
                    for (CraftingItemStack cit : tests2) {
                        if (!ItemUtil.areBaseItemsIdentical(cit.getItemStack(), (ItemStack)string)) continue;
                        CraftBookPlugin.logDebugMessage("Recipe base item is correct!", "advanced-data");
                        if (ItemUtil.areItemsIdentical(cit.getItemStack(), (ItemStack)string)) {
                            leftovers.remove(string);
                            CraftBookPlugin.logDebugMessage("MetaData is correct!", "advanced-data");
                            continue;
                        }
                        CraftBookPlugin.logDebugMessage("MetaData is incorrect!", "advanced-data");
                        hasFailed = true;
                        continue block5;
                    }
                }
                if (!leftovers.isEmpty()) continue;
                hasFailed = false;
                if (p != null && recipe.hasAdvancedData("permission-node")) {
                    CraftBookPlugin.logDebugMessage("A recipe with permission nodes detected!", "advanced-data");
                    if (!p.hasPermission((String)recipe.getAdvancedData("permission-node"))) {
                        if (recipe.hasAdvancedData("permission-error")) {
                            lp.printError((String)recipe.getAdvancedData("permission-error"));
                        } else {
                            lp.printError("mech.custom-crafting.recipe-permission");
                        }
                        ((CraftingInventory)event.getView().getTopInventory()).setResult(null);
                        return;
                    }
                }
                CraftBookPlugin.logDebugMessage("A recipe with custom data is being crafted!", "advanced-data");
                bits = CustomCrafting.applyAdvancedEffects(event.getRecipe().getResult(), recipeRecipeEntry.getKey(), p);
                break;
            }
            if (hasFailed) {
                throw new InvalidCraftingException("Unmet Item Meta");
            }
        }
        catch (InvalidCraftingException e) {
            ((CraftingInventory)event.getView().getTopInventory()).setResult(null);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            ((CraftingInventory)event.getView().getTopInventory()).setResult(null);
            return;
        }
        if (bits != null && !bits.equals((Object)event.getRecipe().getResult())) {
            bits.setAmount(((CraftingInventory)event.getView().getTopInventory()).getResult().getAmount());
            ((CraftingInventory)event.getView().getTopInventory()).setResult(bits);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void prepareFurnace(InventoryClickEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!(event.getInventory() instanceof FurnaceInventory)) {
            return;
        }
        if (event.getAction() != InventoryAction.PLACE_ALL && event.getAction() != InventoryAction.PLACE_ONE && event.getAction() != InventoryAction.PLACE_SOME) {
            return;
        }
        if (event.getSlot() != 0) {
            return;
        }
        boolean shouldCancel = false;
        for (Map.Entry<Recipe, RecipeManager.Recipe> recipeRecipeEntry : advancedRecipes.entrySet()) {
            FurnaceRecipe frec;
            if (!(recipeRecipeEntry.getKey() instanceof FurnaceRecipe) || !ItemUtil.areBaseItemsIdentical((frec = (FurnaceRecipe)recipeRecipeEntry.getKey()).getInput(), event.getCurrentItem())) continue;
            RecipeManager.Recipe recipe = recipeRecipeEntry.getValue();
            if (ItemUtil.areItemsIdentical(event.getCurrentItem(), recipe.getIngredients().get(0).getItemStack())) {
                shouldCancel = false;
                break;
            }
            shouldCancel = true;
        }
        if (shouldCancel) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onFurnaceCook(FurnaceSmeltEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        ItemStack bits = null;
        CraftBookPlugin.logDebugMessage("Smelting has been initiated!", "advanced-data");
        for (Map.Entry<Recipe, RecipeManager.Recipe> recipeRecipeEntry : advancedRecipes.entrySet()) {
            if (!(recipeRecipeEntry.getKey() instanceof FurnaceRecipe)) continue;
            try {
                if (!CustomCrafting.checkFurnaceRecipes((FurnaceRecipe)recipeRecipeEntry.getKey(), event.getSource(), event.getResult())) continue;
                RecipeManager.Recipe recipe = recipeRecipeEntry.getValue();
                ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
                leftovers.add(event.getSource());
                leftovers.removeAll(Collections.singleton(null));
                if (!ItemUtil.isStackValid(event.getSource())) continue;
                for (CraftingItemStack cit : recipe.getIngredients()) {
                    if (!ItemUtil.areBaseItemsIdentical(cit.getItemStack(), event.getSource())) continue;
                    CraftBookPlugin.logDebugMessage("Base item is correct!", "advanced-data");
                    if (ItemUtil.areItemsIdentical(cit.getItemStack(), event.getSource())) {
                        leftovers.remove(event.getSource());
                        CraftBookPlugin.logDebugMessage("MetaData correct!", "advanced-data");
                        continue;
                    }
                    CraftBookPlugin.logDebugMessage("MetaData incorrect!", "advanced-data");
                    throw new InvalidCraftingException("Unmet Item Meta");
                }
                if (!leftovers.isEmpty()) continue;
                CraftBookPlugin.logDebugMessage("A recipe with custom data is being smelted!", "advanced-data");
                bits = CustomCrafting.applyAdvancedEffects(event.getResult(), recipeRecipeEntry.getKey(), null);
                break;
            }
            catch (InvalidCraftingException e) {
                event.setResult(null);
                event.setCancelled(true);
                return;
            }
        }
        if (bits != null && !bits.equals((Object)event.getResult())) {
            bits.setAmount(event.getResult().getAmount());
            event.setResult(bits);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCraft(CraftItemEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlugin.logDebugMessage("Crafting has been initiated!", "advanced-data");
        org.bukkit.entity.Player p = (org.bukkit.entity.Player)event.getWhoClicked();
        for (Map.Entry<Recipe, RecipeManager.Recipe> recipeRecipeEntry : advancedRecipes.entrySet()) {
            if (!ItemUtil.areRecipesIdentical(recipeRecipeEntry.getKey(), event.getRecipe())) continue;
            CraftBookPlugin.logDebugMessage("A recipe with custom data is being crafted!", "advanced-data");
            RecipeManager.Recipe recipe = recipeRecipeEntry.getValue();
            this.applyPostData(recipe, p, (InventoryClickEvent)event);
            event.setCurrentItem(CustomCrafting.applyAdvancedEffects(event.getCurrentItem(), event.getRecipe(), (org.bukkit.entity.Player)event.getWhoClicked()));
            break;
        }
    }

    public void applyPostData(RecipeManager.Recipe recipe, org.bukkit.entity.Player p, InventoryClickEvent event) {
        CraftBookPlayer localPlayer = CraftBookPlugin.inst().wrapPlayer(p);
        if (recipe.hasAdvancedData("permission-node")) {
            CraftBookPlugin.logDebugMessage("A recipe with permission nodes detected!", "advanced-data");
            if (!event.getWhoClicked().hasPermission((String)recipe.getAdvancedData("permission-node"))) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to craft this recipe!");
                event.setCancelled(true);
                return;
            }
        }
        if (recipe.hasAdvancedData("extra-results")) {
            CraftBookPlugin.logDebugMessage("A recipe with extra results is detected!", "advanced-data");
            ArrayList stacks = new ArrayList((Collection)recipe.getAdvancedData("extra-results"));
            for (CraftingItemStack stack : stacks) {
                HashMap leftovers;
                if (stack.hasAdvancedData("chance") && ThreadLocalRandom.current().nextDouble() < (Double)stack.getAdvancedData("chance") || (leftovers = event.getWhoClicked().getInventory().addItem(new ItemStack[]{stack.getItemStack()})).isEmpty()) continue;
                for (ItemStack istack : leftovers.values()) {
                    event.getWhoClicked().getWorld().dropItemNaturally(event.getWhoClicked().getLocation(), istack);
                }
            }
        }
        if (recipe.hasAdvancedData("commands-player") || recipe.hasAdvancedData("commands-console")) {
            CraftBookPlugin.logDebugMessage("A recipe with commands is detected!", "advanced-data");
            if (recipe.hasAdvancedData("commands-console")) {
                for (String s : (List)recipe.getAdvancedData("commands-console")) {
                    s = ParsingUtil.parseLine(s, (Player)localPlayer);
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)s);
                }
            }
            if (recipe.hasAdvancedData("commands-player")) {
                for (String s : (List)recipe.getAdvancedData("commands-player")) {
                    s = ParsingUtil.parseLine(s, (Player)localPlayer);
                    PermissionAttachment att = p.addAttachment((Plugin)CraftBookPlugin.inst());
                    att.setPermission("*", true);
                    boolean wasOp = p.isOp();
                    p.setOp(true);
                    Bukkit.dispatchCommand((CommandSender)p, (String)s);
                    att.remove();
                    p.setOp(wasOp);
                }
            }
        }
    }

    public static ItemStack craftItem(Recipe recipe) {
        for (Recipe rec : advancedRecipes.keySet()) {
            if (!ItemUtil.areRecipesIdentical(rec, recipe)) continue;
            return CustomCrafting.applyAdvancedEffects(recipe.getResult(), rec, null);
        }
        return recipe.getResult();
    }

    private static ItemStack applyAdvancedEffects(ItemStack stack, Recipe rep, org.bukkit.entity.Player player) {
        RecipeManager.Recipe recipe = advancedRecipes.get(rep);
        if (recipe == null) {
            return stack;
        }
        ItemStack res = stack.clone();
        if (recipe.getResult().hasAdvancedData("item-meta")) {
            res.setItemMeta(recipe.getResult().getItemStack().getItemMeta());
        }
        return res;
    }

    private static boolean checkFurnaceRecipes(FurnaceRecipe rec1, ItemStack source, ItemStack result) {
        return ItemUtil.areBaseItemsIdentical(rec1.getInput(), source) && ItemUtil.areBaseItemsIdentical(rec1.getResult(), result);
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
    }

    static {
        registeredNames = new HashSet<String>();
        advancedRecipes = new HashMap<Recipe, RecipeManager.Recipe>();
    }
}

