/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.cauldron;

import com.sk89q.util.yaml.YAMLProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanics.cauldron.CauldronItemStack;
import org.enginehub.craftbook.mechanics.cauldron.ImprovedCauldron;
import org.enginehub.craftbook.util.ItemSyntax;
import org.enginehub.craftbook.util.ItemUtil;

public class ImprovedCauldronCookbook {
    private Collection<Recipe> recipes;
    protected final YAMLProcessor config;

    public ImprovedCauldronCookbook(YAMLProcessor config) {
        this.config = config;
        this.load();
    }

    public void load() {
        this.recipes = new ArrayList<Recipe>();
        if (this.config == null) {
            return;
        }
        try {
            this.config.load();
        }
        catch (IOException e) {
            CraftBook.LOGGER.error("Corrupt Cauldron cauldron-recipes.yml File! Make sure that the correct syntax has been used, and that there are no tabs!");
            e.printStackTrace();
        }
        List keys = this.config.getKeys("cauldron-recipes");
        if (keys != null) {
            for (String key : keys) {
                this.recipes.add(new Recipe(key, this.config));
            }
        }
    }

    public boolean hasRecipes() {
        return this.recipes.size() > 0;
    }

    public Recipe getRecipe(Collection<CauldronItemStack> items) throws ImprovedCauldron.UnknownRecipeException {
        for (Recipe recipe : this.recipes) {
            if (!recipe.checkIngredients(items)) continue;
            return recipe;
        }
        throw new ImprovedCauldron.UnknownRecipeException("Are you sure you have the right ingredients?");
    }

    public static final class Recipe {
        private final String id;
        private final YAMLProcessor config;
        private String name;
        private String description;
        private Collection<CauldronItemStack> ingredients;
        private Collection<CauldronItemStack> results;
        private double chance;

        private Recipe(String id, YAMLProcessor config) {
            this.id = id;
            this.config = config;
            this.ingredients = new ArrayList<CauldronItemStack>();
            this.results = new ArrayList<CauldronItemStack>();
            this.chance = 60.0;
            this.load();
        }

        private void load() {
            this.name = this.config.getString("cauldron-recipes." + this.id + ".name");
            this.description = this.config.getString("cauldron-recipes." + this.id + ".description");
            this.ingredients = this.getItems("cauldron-recipes." + this.id + ".ingredients");
            this.results = this.getItems("cauldron-recipes." + this.id + ".results");
            this.chance = this.config.getDouble("cauldron-recipes." + this.id + ".chance", 60.0);
        }

        private Collection<CauldronItemStack> getItems(String path) {
            ArrayList<CauldronItemStack> items = new ArrayList<CauldronItemStack>();
            try {
                for (Object oitem : this.config.getKeys(path)) {
                    String okey = String.valueOf(oitem);
                    String item = okey.trim();
                    ItemStack stack = ItemUtil.makeItemValid(ItemSyntax.getItem(item));
                    if (stack == null) continue;
                    stack.setAmount(this.config.getInt(path + "." + okey, 1));
                    CauldronItemStack itemStack = new CauldronItemStack(stack);
                    items.add(itemStack);
                }
            }
            catch (Exception e) {
                CraftBook.LOGGER.error("An error occured generating ingredients for cauldron recipe: " + this.id);
                e.printStackTrace();
            }
            return items;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public double getChance() {
            return this.chance;
        }

        public boolean checkIngredients(Collection<CauldronItemStack> items) {
            if (items.size() <= 0) {
                return false;
            }
            int count = 0;
            for (CauldronItemStack item : items) {
                if (!this.ingredients.contains(item)) {
                    return false;
                }
                ++count;
            }
            return count == this.ingredients.size();
        }

        public Collection<CauldronItemStack> getResults() {
            return this.results;
        }
    }
}

