/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.cauldron;

import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.world.item.ItemType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitCraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SourcedBlockRedstoneEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.cauldron.CauldronItemStack;
import org.enginehub.craftbook.mechanics.cauldron.ImprovedCauldronCookbook;
import org.enginehub.craftbook.util.BlockUtil;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.LocationUtil;
import org.enginehub.craftbook.util.SignUtil;

public class ImprovedCauldron
extends AbstractCraftBookMechanic
implements Listener {
    public static ImprovedCauldron instance;
    public ImprovedCauldronCookbook recipes;
    private boolean useSpoons;
    private boolean allowRedstone;
    private boolean itemTracking;
    private boolean requireSign;

    public ImprovedCauldron(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() {
        instance = this;
        CraftBookPlugin.inst().createDefaultConfiguration("cauldron-recipes.yml");
        this.recipes = new ImprovedCauldronCookbook(new YAMLProcessor(new File(CraftBookPlugin.inst().getDataFolder(), "cauldron-recipes.yml"), true, YAMLFormat.EXTENDED));
    }

    @Override
    public void disable() {
        this.recipes = null;
        instance = null;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.getLine(1).equalsIgnoreCase("[Cauldron]")) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.mech.cauldron")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError("mech.create-permission");
            }
            SignUtil.cancelSignChange(event);
            return;
        }
        event.setLine(1, "[Cauldron]");
        player.print("mech.cauldron.create");
    }

    private boolean isCauldron(Block block) {
        if (!block.getWorld().isChunkLoaded(block.getX() >> 4, block.getZ() >> 4)) {
            return false;
        }
        if (block.getType() == Material.WATER_CAULDRON && (block.getRelative(BlockFace.DOWN).getType() == Material.FIRE || block.getRelative(BlockFace.DOWN).getType() == Material.LAVA)) {
            BlockData data;
            if (this.requireSign) {
                BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
                boolean found = false;
                for (BlockFace face : faces) {
                    Block sign = block.getRelative(face);
                    if (!SignUtil.isWallSign(sign)) continue;
                    Sign s = (Sign)sign.getState(false);
                    if (!PlainTextComponentSerializer.plainText().serialize(s.line(1)).equals("[Cauldron]")) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
            if ((data = block.getBlockData()) instanceof Levelled) {
                Levelled levelled = (Levelled)data;
                return levelled.getLevel() == levelled.getMaximumLevel();
            }
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!this.isCauldron(event.getClickedBlock())) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (this.performCauldron(event.getClickedBlock(), player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRedstoneUpdate(SourcedBlockRedstoneEvent event) {
        if (!this.allowRedstone) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!this.isCauldron(event.getBlock())) {
            return;
        }
        this.performCauldron(event.getBlock(), null);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemDrop(PlayerDropItemEvent event) {
        if (!this.itemTracking) {
            return;
        }
        if (!event.getPlayer().hasPermission("craftbook.mech.cauldron.use")) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        new ItemTracker(event.getItemDrop()).runTaskTimer((Plugin)CraftBookPlugin.inst(), 1L, 1L);
    }

    public boolean trackCauldronItem(Item item) {
        Block cauldron;
        if (this.isCauldron(item.getLocation().getBlock())) {
            cauldron = item.getLocation().getBlock();
        } else if (this.isCauldron(item.getLocation().getBlock().getRelative(BlockFace.DOWN))) {
            cauldron = item.getLocation().getBlock().getRelative(BlockFace.DOWN);
        } else {
            return false;
        }
        new CauldronItemTracker(cauldron, item).runTaskTimer((Plugin)CraftBookPlugin.inst(), 1L, 1L);
        return true;
    }

    public boolean performCauldron(Block block, CraftBookPlayer player) {
        block9: {
            if (player != null && !player.hasPermission("craftbook.mech.cauldron.use")) {
                if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                    player.printError("mech.use-permission");
                }
                return false;
            }
            try {
                Collection<Item> items = ImprovedCauldron.getItems(block);
                ImprovedCauldronCookbook.Recipe recipe = this.recipes.getRecipe(CauldronItemStack.convert(items));
                if (player != null && !player.hasPermission("craftbook.mech.cauldron.recipe.*") && !player.hasPermission("craftbook.mech.cauldron.recipe." + recipe.getId())) {
                    player.printError("mech.cauldron.permissions");
                    return false;
                }
                if (!this.useSpoons || player == null && this.allowRedstone) {
                    ImprovedCauldron.cook(block, recipe, items);
                    if (player != null) {
                        player.print("You have cooked the " + String.valueOf(ChatColor.AQUA) + recipe.getName() + String.valueOf(ChatColor.YELLOW) + " recipe.");
                    }
                    block.getWorld().createExplosion(block.getRelative(BlockFace.UP).getLocation(), 0.0f, false);
                    return true;
                }
                if (player != null && ImprovedCauldron.isItemSpoon(BukkitAdapter.adapt((ItemType)player.getItemInHand(HandSide.MAIN_HAND).getType()))) {
                    double chance = ImprovedCauldron.getSpoonChance(((BukkitCraftBookPlayer)player).getPlayer().getItemInHand(), recipe.getChance());
                    double ran = ThreadLocalRandom.current().nextDouble();
                    ((BukkitCraftBookPlayer)player).getPlayer().getItemInHand().setDurability((short)(((BukkitCraftBookPlayer)player).getPlayer().getItemInHand().getDurability() - 1));
                    if (chance <= ran) {
                        ImprovedCauldron.cook(block, recipe, items);
                        player.print(player.translate("mech.cauldron.cook") + " " + String.valueOf(ChatColor.AQUA) + recipe.getName());
                        block.getWorld().createExplosion(block.getRelative(BlockFace.UP).getLocation(), 0.0f, false);
                        return true;
                    }
                    player.print("mech.cauldron.stir");
                }
            }
            catch (UnknownRecipeException e) {
                if (player == null) break block9;
                player.printError(e.getMessage());
            }
        }
        return false;
    }

    public static boolean isItemSpoon(Material id) {
        return id == Material.WOODEN_SHOVEL || id == Material.STONE_SHOVEL || id == Material.IRON_SHOVEL || id == Material.DIAMOND_SHOVEL || id == Material.GOLDEN_SHOVEL;
    }

    public static double getSpoonChance(ItemStack item, double chance) {
        Material id = item.getType();
        double temp = chance / 100.0;
        if (temp > 1.0) {
            return 1.0;
        }
        double toGo = temp = 1.0 - temp;
        double tenth = toGo / 10.0;
        int multiplier = 0;
        switch (id) {
            case WOODEN_SHOVEL: {
                multiplier = 1;
                break;
            }
            case STONE_SHOVEL: {
                multiplier = 2;
                break;
            }
            case IRON_SHOVEL: {
                multiplier = 3;
                break;
            }
            case DIAMOND_SHOVEL: {
                multiplier = 4;
                break;
            }
            case GOLDEN_SHOVEL: {
                multiplier = 5;
                break;
            }
        }
        return temp + tenth * (double)(multiplier += item.getEnchantmentLevel(Enchantment.EFFICIENCY));
    }

    private static void cook(Block block, ImprovedCauldronCookbook.Recipe recipe, Collection<Item> items) {
        for (Item item : items) {
            item.remove();
        }
        for (CauldronItemStack stack : recipe.getResults()) {
            block.getWorld().dropItemNaturally(block.getLocation(), stack.getItemStack());
        }
    }

    private static Collection<Item> getItems(Block block) {
        ArrayList<Item> items = new ArrayList<Item>();
        BoundingBox box = BoundingBox.of((Block)block).expand(BlockFace.UP, 1.0);
        for (Entity entity : block.getWorld().getNearbyEntities(box)) {
            if (!(entity instanceof Item)) continue;
            items.add((Item)entity);
        }
        return items;
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("spoons", "Require spoons to cook cauldron recipes.");
        this.useSpoons = config.getBoolean("spoons", true);
        config.setComment("enable-redstone", "Allows use of cauldrons via redstone.");
        this.allowRedstone = config.getBoolean("enable-redstone", false);
        config.setComment("item-tracking", "Tracks items and forces them to to tracked by the cauldron. Fixes mc bugs by holding item in place.");
        this.itemTracking = config.getBoolean("item-tracking", false);
        config.setComment("require-sign", "Requires a [Cauldron] sign to be on the side of a cauldron. Useful for requiring creation permissions.");
        this.requireSign = config.getBoolean("require-sign", false);
    }

    public class ItemTracker
    extends BukkitRunnable {
        private Location lastLocation;
        private Item item;

        public ItemTracker(Item item) {
            this.lastLocation = new Location(item.getLocation().getWorld(), 2.147483647E9, 2.147483647E9, 2.147483647E9);
            this.item = item;
        }

        public void run() {
            if (this.item == null) {
                this.cancel();
                return;
            }
            if (ImprovedCauldron.this.trackCauldronItem(this.item) || LocationUtil.equals(this.lastLocation, this.item.getLocation())) {
                this.cancel();
            }
        }
    }

    public class CauldronItemTracker
    extends BukkitRunnable {
        private Item item;
        private Block block;

        public CauldronItemTracker(Block block, Item item) {
            this.item = item;
            this.block = block;
        }

        public void run() {
            if (this.item == null) {
                this.cancel();
                return;
            }
            if (!ImprovedCauldron.this.isCauldron(this.block)) {
                this.cancel();
                return;
            }
            this.item.teleport(BlockUtil.getBlockCentre(this.block).add(0.0, 0.5, 0.0));
            this.item.setVelocity(new Vector(0.0, 0.01, 0.0));
        }
    }

    public static class UnknownRecipeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnknownRecipeException(String message) {
            super(message);
        }
    }
}

