/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.cauldron;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.util.ItemSyntax;
import org.enginehub.craftbook.util.ItemUtil;

public class CauldronItemStack
implements Comparable<CauldronItemStack> {
    private ItemStack item;

    public static Collection<CauldronItemStack> convert(Collection<Item> stacks) {
        HashSet<ItemStack> items = new HashSet<ItemStack>();
        for (Item item : stacks) {
            ItemStack stack = item.getItemStack();
            boolean has = false;
            Iterator stackit = items.iterator();
            while (stackit.hasNext()) {
                ItemStack cstack = (ItemStack)stackit.next();
                if (!ItemUtil.areItemsIdentical(cstack, stack)) continue;
                stackit.remove();
                ItemUtil.addToStack(stack, cstack);
                items.add(stack);
                has = true;
                break;
            }
            if (has) continue;
            items.add(stack);
        }
        LinkedHashSet<CauldronItemStack> stackSet = new LinkedHashSet<CauldronItemStack>();
        for (ItemStack stack : items) {
            stackSet.add(new CauldronItemStack(stack));
        }
        return stackSet;
    }

    public CauldronItemStack(ItemStack item) {
        this.item = item;
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public CauldronItemStack add(CauldronItemStack stack) {
        if (stack.isSameType(this)) {
            ItemUtil.addToStack(this.item, stack.item);
        }
        return this;
    }

    public boolean isSameType(CauldronItemStack stack) {
        return ItemUtil.areItemsIdentical(this.item, stack.item);
    }

    @Override
    public int compareTo(CauldronItemStack stack) {
        return Integer.compare(stack.item.getAmount(), this.item.getAmount());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.item.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CauldronItemStack) {
            CauldronItemStack stack = (CauldronItemStack)obj;
            return this.isSameType(stack) && stack.item.getAmount() == this.item.getAmount();
        }
        return false;
    }

    public String toString() {
        return ItemSyntax.getStringFromItem(this.item);
    }
}

