/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.betterai;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.entity.EntityTypes;
import java.util.List;
import java.util.Set;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;

public abstract class BetterAI
extends AbstractCraftBookMechanic {
    protected Set<String> enhancedVision;
    protected Set<String> criticalBow;
    protected Set<String> attackPassive;
    protected boolean attackPassiveIgnoreHostileMounts;
    protected Set<String> fleeFromWeapons;
    protected Set<String> sizeVariance;
    protected boolean sizeVarianceAllowBreeding;
    protected double sizeVarianceVariability;
    protected double sizeVarianceBreedingVariability;

    public BetterAI(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    protected static boolean areAllDisabled(Set<?> ... entitySets) {
        for (Set<?> entitySet : entitySets) {
            if (entitySet.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("enhanced-vision-enabled", "The list of entities to enable the enhanced vision AI mechanic for.");
        this.enhancedVision = Set.copyOf(config.getStringList("enhanced-vision-enabled", List.of(EntityTypes.ZOMBIE.id(), EntityTypes.DROWNED.id(), EntityTypes.HUSK.id(), EntityTypes.ZOMBIFIED_PIGLIN.id())));
        config.setComment("critical-bow-enabled", "The list of entities to enable the critical bow AI mechanic for.");
        this.criticalBow = Set.copyOf(config.getStringList("critical-bow-enabled", List.of(EntityTypes.SKELETON.id())));
        config.setComment("attack-passive-enabled", "The list of entities to enable the attack passive AI mechanic for.");
        this.attackPassive = Set.copyOf(config.getStringList("attack-passive-enabled", List.of(EntityTypes.ZOMBIE.id(), EntityTypes.DROWNED.id(), EntityTypes.HUSK.id())));
        config.setComment("attack-passive-ignore-hostile-mounts", "Whether hostile mobs will ignore passive entities that are mounted by a hostile entity.");
        this.attackPassiveIgnoreHostileMounts = config.getBoolean("attack-passive-ignore-hostile-mounts", true);
        config.setComment("flee-from-weapons", "The list of entities to enable the flee from weapons AI mechanic for.");
        this.fleeFromWeapons = Set.copyOf(config.getStringList("flee-from-weapons", List.of(EntityTypes.CHICKEN.id(), EntityTypes.PIG.id(), EntityTypes.COW.id(), EntityTypes.MOOSHROOM.id(), EntityTypes.SHEEP.id())));
        config.setComment("size-variance", "The list of entities to enable the size variance AI mechanic for.");
        this.sizeVariance = Set.copyOf(config.getStringList("size-variance", List.of(EntityTypes.CHICKEN.id(), EntityTypes.PIG.id(), EntityTypes.COW.id(), EntityTypes.MOOSHROOM.id(), EntityTypes.SHEEP.id())));
        config.setComment("size-variance-allow-breeding", "Whether size variance also applies when breeding entities together.");
        this.sizeVarianceAllowBreeding = config.getBoolean("size-variance-allow-breeding", true);
        config.setComment("size-variance-variability", "The possible variability from default size to apply to the entities.");
        this.sizeVarianceVariability = config.getDouble("size-variance-variability", 0.2);
        config.setComment("size-variance-breeding-variability", "The possible variability from the bred size to apply while breeding entities.");
        this.sizeVarianceBreedingVariability = config.getDouble("size-variance-breeding-variability", 0.1);
    }
}

