/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.area.clipboard;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.Location;
import java.util.regex.Pattern;
import net.kyori.adventure.text.TextReplacementConfig;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;

public abstract class ToggleArea
extends AbstractCraftBookMechanic {
    protected static final TextReplacementConfig DASH_REMOVER = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("-").replacement("").build();
    protected static final Pattern TOGGLED_ON_PATTERN = Pattern.compile("^-[A-Za-z0-9_]*?-$");
    public boolean allowRedstone;
    public boolean removeEntitiesOnToggle;
    public int maxAreaSize;
    public int maxAreasPerUser;

    public ToggleArea(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    public abstract boolean toggleCold(Actor var1, Location var2);

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("allow-redstone", "Allow ToggleAreas to be toggled via redstone.");
        this.allowRedstone = config.getBoolean("allow-redstone", true);
        config.setComment("remove-entities-on-toggle", "Whether the area toggling will remove entities within it.");
        this.removeEntitiesOnToggle = config.getBoolean("remove-entities-on-toggle", false);
        config.setComment("max-size", "Sets the max amount of blocks that a ToggleArea can hold.");
        this.maxAreaSize = config.getInt("max-size", 5000);
        config.setComment("max-per-user", "Sets the max amount of ToggleAreas that can be within one personal namespace.");
        this.maxAreasPerUser = config.getInt("max-per-user", 30);
    }

    public record ToggleAreaData(String namespace, String areaOn, String areaOff) {
    }
}

