/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.area.clipboard;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.regex.Pattern;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanic.MechanicTypes;
import org.enginehub.craftbook.mechanics.area.clipboard.ToggleArea;
import org.enginehub.craftbook.util.HistoryHashMap;
import org.jspecify.annotations.Nullable;

public class CopyManager {
    private static final CopyManager INSTANCE = new CopyManager();
    private static final Pattern NAME_PATTERN = Pattern.compile("^[a-z0-9_]+$", 2);
    public static final int MAX_NAMESPACE_LENGTH = 15;
    public static final int MAX_AREA_NAME_LENGTH = 13;
    private final HistoryHashMap<String, Clipboard> cache = new HistoryHashMap(10);
    private final HistoryHashMap<String, Long> missing = new HistoryHashMap(10);

    public static CopyManager getInstance() {
        return INSTANCE;
    }

    private ToggleArea getToggleAreaInstance() {
        return CraftBook.getInstance().getPlatform().getMechanicManager().getMechanic(MechanicTypes.TOGGLE_AREA.get()).get();
    }

    public static Path getAreaPath() {
        return CraftBook.getInstance().getPlatform().getWorkingDirectory().resolve("areas");
    }

    public static boolean isValidName(String name) {
        return !name.isEmpty() && name.length() <= 13 && NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isValidNamespace(String name) {
        return !name.isEmpty() && name.length() <= 15 && NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isExistingArea(String namespace, String area) {
        area = area.replace("-", "");
        Path namespacePath = CopyManager.getAreaPath().resolve(namespace);
        if (!Files.exists(namespacePath.resolve(area + CopyManager.getDefaultFileSuffix()), new LinkOption[0])) {
            boolean found = false;
            for (String extension : ClipboardFormats.getFileExtensionArray()) {
                if (!Files.exists(namespacePath.resolve(area + "." + extension), new LinkOption[0])) continue;
                found = true;
                break;
            }
            return found;
        }
        return true;
    }

    public Clipboard load(String namespace, String id) throws IOException {
        long lastCheck;
        String cacheKey = namespace + "/" + (id = id.toLowerCase(Locale.ENGLISH));
        if (this.missing.containsKey(cacheKey) && (lastCheck = ((Long)this.missing.get(cacheKey)).longValue()) > System.currentTimeMillis() - 60000L) {
            throw new FileNotFoundException(id);
        }
        Clipboard copy = (Clipboard)this.cache.get(cacheKey);
        if (copy == null) {
            Path namespacePath = CopyManager.getAreaPath().resolve(namespace);
            Path path = namespacePath.resolve(id + CopyManager.getDefaultFileSuffix());
            if (!Files.exists(path, new LinkOption[0])) {
                String extension;
                String[] stringArray = ClipboardFormats.getFileExtensionArray();
                int n = stringArray.length;
                for (int i = 0; i < n && !Files.exists(path = namespacePath.resolve(id + "." + (extension = stringArray[i])), new LinkOption[0]); ++i) {
                }
            }
            if (Files.exists(path, new LinkOption[0])) {
                ClipboardFormat format = ClipboardFormats.findByPath((Path)path);
                if (format == null) {
                    this.missing.put(cacheKey, System.currentTimeMillis());
                    throw new IOException("Unknown clipboard format!");
                }
                try (ClipboardReader reader = format.getReader(Files.newInputStream(path, new OpenOption[0]));){
                    copy = reader.read();
                    this.missing.remove(cacheKey);
                    this.cache.put(cacheKey, copy);
                    Clipboard clipboard = copy;
                    return clipboard;
                }
            }
            this.missing.put(cacheKey, System.currentTimeMillis());
            throw new FileNotFoundException(id);
        }
        return copy;
    }

    public void save(String namespace, String id, Clipboard clipboard) throws IOException {
        Path namespacePath = CopyManager.getAreaPath().resolve(namespace);
        if (!Files.exists(namespacePath, new LinkOption[0])) {
            Files.createDirectories(namespacePath, new FileAttribute[0]);
        }
        id = id.toLowerCase(Locale.ENGLISH);
        String cacheKey = namespace + "/" + id;
        Path path = namespacePath.resolve(id + CopyManager.getDefaultFileSuffix());
        try (ClipboardWriter writer = CopyManager.getDefaultClipboardFormat().getWriter(Files.newOutputStream(path, new OpenOption[0]));){
            writer.write(clipboard);
        }
        this.missing.remove(cacheKey);
        this.cache.put(cacheKey, clipboard);
    }

    public Clipboard copy(Region region, World world) throws WorldEditException {
        return this.copy(region, world, false, false);
    }

    public Clipboard copy(Region region, World world, boolean copyEntities, boolean copyBiomes) throws WorldEditException {
        BlockArrayClipboard copy = new BlockArrayClipboard(region);
        EditSession editSession = WorldEdit.getInstance().newEditSession(world);
        editSession.setTrackingHistory(false);
        ForwardExtentCopy forwardExtentCopy = new ForwardExtentCopy((Extent)editSession, region, (Extent)copy, region.getMinimumPoint());
        forwardExtentCopy.setCopyingEntities(copyEntities);
        forwardExtentCopy.setCopyingBiomes(copyBiomes);
        Operations.complete((Operation)forwardExtentCopy);
        return copy;
    }

    public void paste(Clipboard clipboard, World world) throws WorldEditException {
        try (EditSession editSession = WorldEdit.getInstance().newEditSession(world);){
            editSession.setTrackingHistory(false);
            if (this.getToggleAreaInstance().removeEntitiesOnToggle) {
                editSession.getEntities(clipboard.getRegion()).forEach(Entity::remove);
            }
            Operation operation = new ClipboardHolder(clipboard).createPaste((Extent)editSession).to(clipboard.getOrigin()).copyBiomes(true).copyEntities(true).ignoreAirBlocks(false).build();
            Operations.complete((Operation)operation);
        }
    }

    public void clear(Clipboard clipboard, World world) {
        try (EditSession editSession = WorldEdit.getInstance().newEditSession(world);){
            editSession.setTrackingHistory(false);
            editSession.setBlocks(clipboard.getRegion(), (BlockStateHolder)BlockTypes.AIR.getDefaultState());
            if (this.getToggleAreaInstance().removeEntitiesOnToggle) {
                editSession.getEntities(clipboard.getRegion()).forEach(Entity::remove);
            }
        }
        catch (MaxChangedBlocksException maxChangedBlocksException) {
            // empty catch block
        }
    }

    public static int meetsQuota(String namespace, @Nullable String ignore, int quota) {
        String[] files = new File(CopyManager.getAreaPath().toFile(), namespace).list();
        if (files == null) {
            return quota > 0 ? -1 : 0;
        }
        if (ignore == null) {
            return files.length < quota ? -1 : files.length;
        }
        int count = 0;
        for (String f : files) {
            if (f.substring(0, f.lastIndexOf(46)).equals(ignore)) {
                return -1;
            }
            ++count;
        }
        return count < quota ? -1 : count;
    }

    private static ClipboardFormat getDefaultClipboardFormat() {
        return BuiltInClipboardFormat.SPONGE_V3_SCHEMATIC;
    }

    private static String getDefaultFileSuffix() {
        return "." + CopyManager.getDefaultClipboardFormat().getPrimaryFileExtension();
    }
}

