/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.area.clipboard;

import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.component.PaginationBox;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import java.nio.file.Path;
import java.util.List;

public class AreaListBox
extends PaginationBox {
    private final Actor actor;
    private final List<Path> areaList;
    private final String namespace;
    private final boolean showAll;

    public AreaListBox(Actor actor, List<Path> areaList, String namespace, boolean showAll) {
        super((String)(showAll ? "Toggle Areas" : (namespace.isBlank() ? "Toggle Areas (" + actor.getName() + ")" : "Toggle Areas (" + namespace + ")")), (String)(showAll ? "/area list -a -p %page%" : (namespace.isBlank() ? "/area list -p %page%" : "/area list -p %page% -n " + namespace)));
        this.actor = actor;
        this.areaList = areaList;
        this.namespace = namespace;
        this.showAll = showAll;
    }

    public Component getComponent(int number) {
        Path area = this.areaList.get(number);
        String filename = area.getFileName().toString();
        if (filename.contains(".")) {
            filename = filename.substring(0, filename.lastIndexOf(46));
        }
        TextComponent areaName = TextComponent.of((String)filename, (TextColor)TextColor.WHITE);
        if (this.actor.isPlayer()) {
            areaName = (TextComponent)areaName.hoverEvent(HoverEvent.showText((Component)TextComponent.of((String)area.toString())));
        }
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().append((Component)areaName)).append((Component)TextComponent.space());
        if (this.actor.isPlayer()) {
            TextComponent copyComponent = (TextComponent)((TextComponent)TextComponent.of((String)"[C]", (TextColor)TextColor.YELLOW).hoverEvent(HoverEvent.showText((Component)TranslatableComponent.of((String)"craftbook.togglearea.copy-name-to-clipboard")))).clickEvent(ClickEvent.copyToClipboard((String)filename));
            int length = FontInfo.getPxLength(filename);
            int leftover = 200 - length - 4;
            if (leftover > 0) {
                builder.append((Component)TextComponent.of((String)".".repeat(leftover / 2), (TextColor)TextColor.DARK_GRAY));
            }
            ((TextComponent.Builder)builder.append((Component)TextComponent.space())).append((Component)copyComponent);
            if (!this.namespace.isBlank() || !this.showAll) {
                TextComponent deleteComponent = (TextComponent)((TextComponent)TextComponent.of((String)"[D]", (TextColor)TextColor.RED).hoverEvent(HoverEvent.showText((Component)TranslatableComponent.of((String)"craftbook.togglearea.delete-area")))).clickEvent(ClickEvent.runCommand((String)("/area delete " + filename + (String)(this.namespace.isBlank() ? "" : " -n " + this.namespace))));
                ((TextComponent.Builder)builder.append((Component)TextComponent.space())).append((Component)deleteComponent);
            }
        }
        return builder.build();
    }

    public int getComponentsSize() {
        return this.areaList.size();
    }

    private static final class FontInfo {
        private FontInfo() {
        }

        static int getPxLength(char c) {
            return switch (c) {
                case ':', 'i' -> 1;
                case 'l' -> 2;
                case '*', 't' -> 3;
                case 'f', 'k' -> 4;
                default -> 5;
            };
        }

        static int getPxLength(String string) {
            return string.chars().reduce(0, (p, i) -> p + FontInfo.getPxLength((char)i) + 1);
        }
    }
}

