/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.area.clipboard;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.World;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.mechanics.area.clipboard.AreaCommands;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class AreaCommandsRegistration
implements CommandRegistration<AreaCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<World> world_Key = Key.of(World.class);
    private static final Key<BlockVector3> blockVector3_Key = Key.of(BlockVector3.class);
    private static final Key<CraftBookPlayer> craftBookPlayer_Key = Key.of(CraftBookPlayer.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private CommandManager commandManager;
    private AreaCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final ArgAcceptingCommandFlag namespacePart = CommandParts.flag((char)'n', (Component)TextComponent.of((String)"The namespace")).withRequiredArg().argNamed(TranslatableComponent.of((String)"namespace")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument namePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"name"), (Component)TextComponent.of((String)"The area name")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final NoArgCommandFlag saveBiomesPart = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Save biomes")).build();
    private final NoArgCommandFlag saveEntitiesPart = CommandParts.flag((char)'e', (Component)TextComponent.of((String)"Save entities")).build();
    private final NoArgCommandFlag listAllPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"List from all namespaces")).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"The page")).withRequiredArg().argNamed(TranslatableComponent.of((String)"page")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final ArgAcceptingCommandFlag worldPart = CommandParts.flag((char)'w', (Component)TextComponent.of((String)"The world")).withRequiredArg().argNamed(TranslatableComponent.of((String)"world")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(world_Key)).build();
    private final CommandArgument positionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"position"), (Component)TextComponent.of((String)"The location")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(blockVector3_Key)).build();
    private final NoArgCommandFlag silentPart = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"Silence output")).build();
    private final CommandArgument namespacePart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"namespace"), (Component)TextComponent.of((String)"The namespace")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).variable(true).build();

    private AreaCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static AreaCommandsRegistration builder() {
        return new AreaCommandsRegistration();
    }

    public AreaCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public AreaCommandsRegistration containerInstance(AreaCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    public AreaCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public AreaCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("save", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Saves the selected area"));
            b.parts((Collection)ImmutableList.of((Object)this.namespacePart, (Object)this.namePart, (Object)this.saveBiomesPart, (Object)this.saveEntitiesPart));
            b.action(this::cmd$save);
            Method commandMethod = RegistrationUtil.getCommandMethod(AreaCommands.class, (String)"save", (Class[])new Class[]{CraftBookPlayer.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("list", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Lists the areas of the given namespace or lists all areas."));
            b.parts((Collection)ImmutableList.of((Object)this.namespacePart, (Object)this.listAllPart, (Object)this.pagePart));
            b.action(this::cmd$list);
            Method commandMethod = RegistrationUtil.getCommandMethod(AreaCommands.class, (String)"list", (Class[])new Class[]{Actor.class, String.class, Boolean.TYPE, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("toggle", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Toggle an area sign at the given location."));
            b.parts((Collection)ImmutableList.of((Object)this.worldPart, (Object)this.positionPart, (Object)this.silentPart));
            b.action(this::cmd$toggle);
            Method commandMethod = RegistrationUtil.getCommandMethod(AreaCommands.class, (String)"toggle", (Class[])new Class[]{Actor.class, World.class, BlockVector3.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("delete", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Lists the areas of the given namespace or lists all areas."));
            b.parts((Collection)ImmutableList.of((Object)this.namespacePart, (Object)this.namePart));
            b.action(this::cmd$delete);
            Method commandMethod = RegistrationUtil.getCommandMethod(AreaCommands.class, (String)"delete", (Class[])new Class[]{Actor.class, String.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("delete-all", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Deletes all the areas in a namespace."));
            b.parts((Collection)ImmutableList.of((Object)this.namespacePart2));
            b.action(this::cmd$delete_all);
            Method commandMethod = RegistrationUtil.getCommandMethod(AreaCommands.class, (String)"deleteAll", (Class[])new Class[]{Actor.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$save(CommandParameters parameters) throws AuthorizationException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(AreaCommands.class, (String)"save", (Class[])new Class[]{CraftBookPlayer.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.save(this.extract$player(parameters), this.extract$namespace(parameters), this.extract$name(parameters), this.extract$saveBiomes(parameters), this.extract$saveEntities(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$list(CommandParameters parameters) throws AuthorizationException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(AreaCommands.class, (String)"list", (Class[])new Class[]{Actor.class, String.class, Boolean.TYPE, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.list(this.extract$actor(parameters), this.extract$namespace(parameters), this.extract$listAll(parameters), this.extract$page(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$toggle(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(AreaCommands.class, (String)"toggle", (Class[])new Class[]{Actor.class, World.class, BlockVector3.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.toggle(this.extract$actor(parameters), this.extract$world(parameters), this.extract$position(parameters), this.extract$silent(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$delete(CommandParameters parameters) throws AuthorizationException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(AreaCommands.class, (String)"delete", (Class[])new Class[]{Actor.class, String.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.delete(this.extract$actor(parameters), this.extract$namespace(parameters), this.extract$name(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$delete_all(CommandParameters parameters) throws AuthorizationException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(AreaCommands.class, (String)"deleteAll", (Class[])new Class[]{Actor.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.deleteAll(this.extract$actor(parameters), this.extract$namespace2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private CraftBookPlayer extract$player(CommandParameters parameters) {
        return (CraftBookPlayer)RegistrationUtil.requireOptional(craftBookPlayer_Key, (String)"player", (Optional)parameters.injectedValue(craftBookPlayer_Key));
    }

    private String extract$namespace(CommandParameters parameters) {
        return (String)this.namespacePart.value(parameters).asSingle(string_Key);
    }

    private String extract$name(CommandParameters parameters) {
        return (String)this.namePart.value(parameters).asSingle(string_Key);
    }

    private boolean extract$saveBiomes(CommandParameters parameters) {
        return this.saveBiomesPart.in(parameters);
    }

    private boolean extract$saveEntities(CommandParameters parameters) {
        return this.saveEntitiesPart.in(parameters);
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private boolean extract$listAll(CommandParameters parameters) {
        return this.listAllPart.in(parameters);
    }

    private int extract$page(CommandParameters parameters) {
        return (Integer)this.pagePart.value(parameters).asSingle(integer_Key);
    }

    private World extract$world(CommandParameters parameters) {
        return (World)this.worldPart.value(parameters).asSingle(world_Key);
    }

    private BlockVector3 extract$position(CommandParameters parameters) {
        return (BlockVector3)this.positionPart.value(parameters).asSingle(blockVector3_Key);
    }

    private boolean extract$silent(CommandParameters parameters) {
        return this.silentPart.in(parameters);
    }

    private String extract$namespace2(CommandParameters parameters) {
        return (String)this.namespacePart2.value(parameters).asSingle(string_Key);
    }
}

