/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.area.clipboard;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.util.formatting.component.InvalidComponentException;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.util.formatting.text.format.TextDecoration;
import com.sk89q.worldedit.world.World;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.mechanics.area.clipboard.AreaCommandsRegistration;
import org.enginehub.craftbook.mechanics.area.clipboard.AreaListBox;
import org.enginehub.craftbook.mechanics.area.clipboard.CopyManager;
import org.enginehub.craftbook.mechanics.area.clipboard.ToggleArea;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.annotation.param.Switch;
import org.enginehub.piston.gen.CommandRegistration;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class AreaCommands {
    private final ToggleArea toggleArea;
    private static final PathMatcher SCHEMATIC_FILTER = path -> {
        String[] extensions = ClipboardFormats.getFileExtensionArray();
        boolean found = false;
        String filename = path.getFileName().toString();
        for (String extension : extensions) {
            if (!filename.endsWith("." + extension)) continue;
            found = true;
            break;
        }
        return found;
    };

    public static void register(CommandManager commandManager, CommandRegistrationHandler registration, ToggleArea toggleArea) {
        registration.register(commandManager, (CommandRegistration)AreaCommandsRegistration.builder(), (Object)new AreaCommands(toggleArea));
    }

    private AreaCommands(ToggleArea toggleArea) {
        this.toggleArea = toggleArea;
    }

    private Component makeFriendlyNamespace(Actor actor, String namespace) {
        Object namespaceComponent = null;
        namespaceComponent = !actor.isPlayer() || !namespace.equalsIgnoreCase(actor.getUniqueId().toString()) ? TextComponent.of((String)namespace) : TranslatableComponent.of((String)("~" + actor.getName()), (TextColor)TextColor.LIGHT_PURPLE, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}).hoverEvent(HoverEvent.showText((Component)TextComponent.of((String)namespace)));
        return namespaceComponent;
    }

    @Command(name="save", desc="Saves the selected area")
    @CommandPermissions(value={"craftbook.togglearea.save"})
    public void save(CraftBookPlayer player, @ArgFlag(name=110, desc="The namespace") String namespace, @Arg(desc="The area name") String name, @Switch(name=98, desc="Save biomes") boolean saveBiomes, @Switch(name=101, desc="Save entities") boolean saveEntities) throws AuthorizationException {
        boolean personal = true;
        if (namespace != null && !namespace.equalsIgnoreCase("self")) {
            if (!player.hasPermission("craftbook.togglearea.save." + namespace)) {
                throw new AuthorizationException((Component)TranslatableComponent.of((String)"craftbook.togglearea.namespace-permissions", (Component[])new Component[]{TextComponent.of((String)namespace, (TextColor)TextColor.DARK_PURPLE)}));
            }
            personal = false;
        } else {
            if (!player.hasPermission("craftbook.togglearea.save.self")) {
                throw new AuthorizationException();
            }
            namespace = player.getUniqueId().toString();
        }
        if (!personal && !CopyManager.isValidNamespace(namespace)) {
            player.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.invalid-namespace"));
            return;
        }
        if (!CopyManager.isValidName(name)) {
            player.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.invalid-area-name"));
            return;
        }
        try {
            int count;
            World world = player.getWorld();
            Region sel = WorldEdit.getInstance().getSessionManager().get((SessionOwner)player).getSelection(world);
            if (sel == null) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.missing-selection"));
                return;
            }
            if (this.toggleArea.maxAreaSize != -1 && sel.getVolume() > (long)this.toggleArea.maxAreaSize) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.selection-too-large", (Component[])new Component[]{TextComponent.of((int)this.toggleArea.maxAreaSize)}));
                return;
            }
            if (personal && this.toggleArea.maxAreasPerUser >= 0 && !player.hasPermission("craftbook.togglearea.bypass-area-limit") && (count = CopyManager.meetsQuota(namespace, name, this.toggleArea.maxAreasPerUser)) > -1) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.too-many-areas", (Component[])new Component[]{TextComponent.of((int)this.toggleArea.maxAreasPerUser), TextComponent.of((int)count)}));
                return;
            }
            Clipboard copy = CopyManager.getInstance().copy(sel, world, saveEntities, saveBiomes);
            CraftBook.LOGGER.info(player.getName() + " saving toggle area with folder '" + namespace + "' and ID '" + name + "'.");
            try {
                CopyManager.getInstance().save(namespace, name.toLowerCase(Locale.ENGLISH), copy);
                player.printInfo((Component)TranslatableComponent.of((String)"craftbook.togglearea.saved", (Component[])new Component[]{TextComponent.of((String)name), this.makeFriendlyNamespace((Actor)player, namespace)}));
            }
            catch (IOException e) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.save-failed", (Component[])new Component[]{TextComponent.of((String)e.getMessage())}));
            }
        }
        catch (IncompleteRegionException e) {
            player.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.missing-selection"));
        }
        catch (WorldEditException e) {
            player.printError(e.getRichMessage());
        }
    }

    @Command(name="list", desc="Lists the areas of the given namespace or lists all areas.")
    @CommandPermissions(value={"craftbook.togglearea.list"})
    public void list(Actor actor, @ArgFlag(name=110, desc="The namespace") String namespace, @Switch(name=97, desc="List from all namespaces") boolean listAll, @ArgFlag(name=112, desc="The page", def={"1"}) int page) throws AuthorizationException {
        Path areasPath;
        boolean personal = false;
        if (namespace != null) {
            if (!actor.hasPermission("craftbook.togglearea.list." + namespace)) {
                throw new AuthorizationException((Component)TranslatableComponent.of((String)"craftbook.togglearea.namespace-permissions", (Component[])new Component[]{TextComponent.of((String)namespace)}));
            }
        } else if (listAll && actor.hasPermission("craftbook.togglearea.list.all")) {
            namespace = "";
        } else if (actor instanceof CraftBookPlayer) {
            if (!actor.hasPermission("craftbook.togglearea.list.self")) {
                throw new AuthorizationException();
            }
            namespace = actor.getUniqueId().toString();
            personal = true;
        } else {
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.player-or-namespace-required"));
            return;
        }
        if (!Files.exists(areasPath = CopyManager.getAreaPath(), new LinkOption[0]) || !Files.isDirectory(areasPath, new LinkOption[0])) {
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.no-areas"));
            return;
        }
        if (!(namespace.isEmpty() || Files.exists(areasPath = areasPath.resolve(namespace), new LinkOption[0]) && Files.isDirectory(areasPath, new LinkOption[0]))) {
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.unknown-namespace", (Component[])new Component[]{TextComponent.of((String)namespace, (TextColor)TextColor.DARK_PURPLE)}));
            return;
        }
        try (Stream<Path> pathStream = Files.walk(areasPath, new FileVisitOption[0]);){
            List<Path> areaList = pathStream.filter(SCHEMATIC_FILTER::matches).toList();
            if (!areaList.isEmpty()) {
                this.showListBox(actor, areaList, page, personal ? "" : namespace, listAll);
            } else {
                actor.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.no-areas-namespace", (Component[])new Component[]{TextComponent.of((String)namespace)}));
            }
        }
        catch (InvalidComponentException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Command(name="toggle", desc="Toggle an area sign at the given location.")
    @CommandPermissions(value={"craftbook.togglearea.toggle-command"})
    public void toggle(Actor actor, @ArgFlag(name=119, desc="The world") World world, @Arg(desc="The location") BlockVector3 position, @Switch(name=115, desc="Silence output") boolean silent) {
        if (world == null && actor instanceof CraftBookPlayer) {
            CraftBookPlayer player = (CraftBookPlayer)actor;
            world = player.getWorld();
        }
        if (world == null) {
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.player-or-world-required"));
            return;
        }
        Location location = new Location((Extent)world, position.toVector3());
        if (!this.toggleArea.toggleCold(actor, location)) {
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.toggle-failed"));
            return;
        }
        if (!silent) {
            actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.togglearea.toggled"));
        }
    }

    @Command(name="delete", desc="Lists the areas of the given namespace or lists all areas.")
    @CommandPermissions(value={"craftbook.togglearea.delete"})
    public void delete(Actor actor, @ArgFlag(name=110, desc="The namespace") String namespace, @Arg(desc="The area name") String name) throws AuthorizationException {
        if (namespace != null && !namespace.equalsIgnoreCase("self")) {
            if (!actor.hasPermission("craftbook.togglearea.delete." + namespace)) {
                actor.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.namespace-permissions", (Component[])new Component[]{TextComponent.of((String)namespace)}));
                return;
            }
        } else if (actor instanceof CraftBookPlayer) {
            if (!actor.hasPermission("craftbook.togglearea.delete.self")) {
                throw new AuthorizationException();
            }
            namespace = actor.getUniqueId().toString();
        } else {
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.player-or-namespace-required"));
            return;
        }
        Path namespaceFolder = CopyManager.getAreaPath().resolve(namespace);
        Component namespaceComponent = this.makeFriendlyNamespace(actor, namespace);
        if (!Files.exists(namespaceFolder, new LinkOption[0]) || !Files.isDirectory(namespaceFolder, new LinkOption[0])) {
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.unknown-namespace", (Component[])new Component[]{namespaceComponent}));
            return;
        }
        List<String> possibleFilenames = Arrays.stream(ClipboardFormats.getFileExtensionArray()).map(ext -> name + "." + ext).toList();
        for (String filename : possibleFilenames) {
            Path areaPath = namespaceFolder.resolve(filename);
            if (!Files.exists(areaPath, new LinkOption[0])) continue;
            try {
                Files.delete(areaPath);
                actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.togglearea.deleted-area", (Component[])new Component[]{TextComponent.of((String)name), namespaceComponent}));
                break;
            }
            catch (IOException e) {
                actor.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.failed-delete", (Component[])new Component[]{TextComponent.of((String)name), namespaceComponent}));
                return;
            }
        }
    }

    @Command(name="delete-all", desc="Deletes all the areas in a namespace.")
    @CommandPermissions(value={"craftbook.togglearea.delete"})
    public void deleteAll(Actor actor, @Arg(desc="The namespace", variable=true) String namespace) throws AuthorizationException {
        if (namespace != null && !namespace.equalsIgnoreCase("self")) {
            if (!actor.hasPermission("craftbook.togglearea.delete." + namespace + ".all")) {
                actor.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.namespace-permissions", (Component[])new Component[]{TextComponent.of((String)namespace)}));
                return;
            }
        } else if (actor instanceof CraftBookPlayer) {
            if (!actor.hasPermission("craftbook.togglearea.delete.self.all")) {
                throw new AuthorizationException();
            }
            namespace = actor.getUniqueId().toString();
        } else {
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.player-or-namespace-required"));
            return;
        }
        Path namespaceFolder = CopyManager.getAreaPath().resolve(namespace);
        Component namespaceComponent = this.makeFriendlyNamespace(actor, namespace);
        if (!Files.exists(namespaceFolder, new LinkOption[0]) || !Files.isDirectory(namespaceFolder, new LinkOption[0])) {
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.unknown-namespace", (Component[])new Component[]{namespaceComponent}));
            return;
        }
        try {
            this.deleteDir(namespaceFolder);
            actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.togglearea.deleted-all-in-namespace", (Component[])new Component[]{namespaceComponent}));
        }
        catch (IOException e) {
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.togglearea.failed-delete-all", (Component[])new Component[]{namespaceComponent}));
        }
    }

    private void deleteDir(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> listStream = Files.list(path);){
                List<Path> children = listStream.filter(SCHEMATIC_FILTER::matches).toList();
                for (Path child : children) {
                    Files.delete(child);
                }
            }
        }
        Files.delete(path);
    }

    private void showListBox(Actor actor, List<Path> areaPaths, int page, String namespace, boolean showAll) throws InvalidComponentException {
        AreaListBox areaListBox = new AreaListBox(actor, areaPaths, namespace, showAll);
        actor.print(areaListBox.create(page));
    }
}

