/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.area;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.sign.Side;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.exception.InvalidMechanismException;
import org.enginehub.craftbook.mechanic.exception.MechanicInitializationException;
import org.enginehub.craftbook.mechanics.pipe.PipeFinishEvent;
import org.enginehub.craftbook.mechanics.pipe.PipePutEvent;
import org.enginehub.craftbook.mechanics.pipe.PipeSuckEvent;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.SignUtil;
import org.jspecify.annotations.Nullable;

public abstract class StoredBlockMechanic
extends AbstractCraftBookMechanic
implements Listener {
    private final NamespacedKey storedBlockTypeKey = new NamespacedKey("craftbook", "toggle_block_type");
    private final NamespacedKey storedBlockQuantityKey = new NamespacedKey("craftbook", "toggle_block_quantity");

    public StoredBlockMechanic(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() throws MechanicInitializationException {
        super.enable();
    }

    public abstract Block getBlockBase(Block var1) throws InvalidMechanismException;

    public abstract boolean isApplicableSign(String var1);

    public boolean isApplicableSign(Sign sign) {
        for (Side side : Side.values()) {
            if (!this.isApplicableSign(PlainTextComponentSerializer.plainText().serialize(sign.getSide(side).line(1)))) continue;
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPipeFinish(PipeFinishEvent event) {
        if (!EventUtil.passesFilter((Event)event) || !SignUtil.isSign(event.getOrigin())) {
            return;
        }
        Sign sign = (Sign)event.getOrigin().getState(false);
        if (!this.isApplicableSign(sign)) {
            return;
        }
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        try {
            Material type = this.getOrSetStoredType(event.getOrigin());
            for (ItemStack stack : event.getItems()) {
                if (stack.getType() != type) {
                    leftovers.add(stack);
                    continue;
                }
                this.addToStoredBlockCount(sign, stack.getAmount());
            }
            event.setItems(leftovers);
        }
        catch (InvalidMechanismException e) {
            CraftBook.LOGGER.error("Failed to store blocks in sign at " + String.valueOf(sign.getLocation()), (Throwable)e);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPipePut(PipePutEvent event) {
        if (!EventUtil.passesFilter((Event)event) || !SignUtil.isSign(event.getPuttingBlock())) {
            return;
        }
        Sign sign = (Sign)event.getPuttingBlock().getState(false);
        if (!this.isApplicableSign(sign)) {
            return;
        }
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        try {
            Material type = this.getOrSetStoredType(event.getPuttingBlock());
            for (ItemStack stack : event.getItems()) {
                if (stack.getType() != type) {
                    leftovers.add(stack);
                    continue;
                }
                this.addToStoredBlockCount(sign, stack.getAmount());
            }
            event.setItems(leftovers);
        }
        catch (InvalidMechanismException e) {
            CraftBook.LOGGER.error("Failed to store blocks in sign at " + String.valueOf(sign.getLocation()), (Throwable)e);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPipeSuck(PipeSuckEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!SignUtil.isSign(event.getSuckedBlock())) {
            return;
        }
        Sign sign = (Sign)event.getSuckedBlock().getState(false);
        if (!this.isApplicableSign(sign)) {
            return;
        }
        List<ItemStack> items = event.getItems();
        try {
            Material base = this.getOrSetStoredType(event.getSuckedBlock());
            int blocks = this.getStoredBlockCount(sign);
            if (blocks > 0) {
                items.add(new ItemStack(base, blocks));
                this.setStoredBlockCount(sign, 0);
            }
            event.setItems(items);
        }
        catch (InvalidMechanismException e) {
            CraftBook.LOGGER.error("Failed to store blocks in sign at " + String.valueOf(sign.getLocation()), (Throwable)e);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        block7: {
            if (!EventUtil.passesFilter((Event)event)) {
                return;
            }
            if (!SignUtil.isSign(event.getBlock())) {
                return;
            }
            Sign sign = (Sign)event.getBlock().getState(false);
            if (!this.isApplicableSign(sign)) {
                return;
            }
            CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
            int amount = this.getStoredBlockCounts(sign);
            if (amount > 0) {
                try {
                    Material base = this.getOrSetStoredType(event.getBlock());
                    while (amount > 0) {
                        ItemStack toDrop = new ItemStack(base, Math.min(amount, 64));
                        event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), toDrop);
                        amount -= 64;
                    }
                    this.resetStoredData(sign);
                }
                catch (InvalidMechanismException e) {
                    if (e.getMessage() == null) break block7;
                    player.printError((Component)TextComponent.of((String)e.getMessage()));
                }
            }
        }
    }

    public boolean takeFromStoredBlockCounts(int amount, Sign ... signs) {
        if (signs.length == 0 || amount < 0 || signs[0] == null) {
            return false;
        }
        if (amount == 0) {
            return true;
        }
        int current = this.getStoredBlockCounts(signs);
        Material type = this.getStoredType(signs[0]);
        if (current < amount) {
            return false;
        }
        for (Sign sign : signs) {
            if (sign == null || this.getStoredType(sign) != type) continue;
            int stored = this.getStoredBlockCount(sign);
            if (stored >= amount) {
                return this.setStoredBlockCount(sign, stored - amount);
            }
            this.setStoredBlockCount(sign, 0);
            amount -= stored;
        }
        return amount == 0;
    }

    public boolean addToStoredBlockCount(Sign sign, int amount) {
        int currentBlocks = this.getStoredBlockCount(sign);
        return this.setStoredBlockCount(sign, currentBlocks + amount);
    }

    public int getStoredBlockCounts(Sign ... signs) {
        if (signs.length == 0 || signs[0] == null) {
            return 0;
        }
        Material type = this.getStoredType(signs[0]);
        int sum = 0;
        for (Sign sign : signs) {
            if (sign == null || this.getStoredType(sign) != type) continue;
            sum += this.getStoredBlockCount(sign);
        }
        return sum;
    }

    public int getStoredBlockCount(Sign sign) {
        if (sign.getPersistentDataContainer().has(this.storedBlockQuantityKey, PersistentDataType.INTEGER)) {
            return (Integer)sign.getPersistentDataContainer().get(this.storedBlockQuantityKey, PersistentDataType.INTEGER);
        }
        return 0;
    }

    public boolean setStoredBlockCount(Sign sign, int count) {
        if (count < 0) {
            return false;
        }
        sign.getPersistentDataContainer().set(this.storedBlockQuantityKey, PersistentDataType.INTEGER, (Object)count);
        return true;
    }

    public @Nullable Material getStoredType(Sign sign) {
        if (sign.getPersistentDataContainer().has(this.storedBlockTypeKey, PersistentDataType.STRING)) {
            String signBlockData = (String)sign.getPersistentDataContainer().get(this.storedBlockTypeKey, PersistentDataType.STRING);
            if (signBlockData == null) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " sign has corrupt stored block type at " + String.valueOf(sign.getLocation()));
            }
            BlockType parsedBlock = (BlockType)BlockType.REGISTRY.get(signBlockData);
            if (parsedBlock == null) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " sign has corrupt stored block type at " + String.valueOf(sign.getLocation()));
            }
            return BukkitAdapter.adapt((BlockType)parsedBlock);
        }
        return null;
    }

    public void setStoredType(Sign sign, Material material) {
        sign.getPersistentDataContainer().set(this.storedBlockTypeKey, PersistentDataType.STRING, (Object)BukkitAdapter.asBlockType((Material)material).id());
    }

    public void resetStoredData(Sign sign) {
        sign.getPersistentDataContainer().remove(this.storedBlockTypeKey);
        sign.getPersistentDataContainer().remove(this.storedBlockQuantityKey);
    }

    public Material getOrSetStoredType(Block block) throws InvalidMechanismException {
        Sign sign = (Sign)block.getState(false);
        Material storedType = this.getStoredType(sign);
        if (storedType == null) {
            Material realType = this.getBlockBase(block).getType();
            this.setStoredType(sign, realType);
            return realType;
        }
        return storedType;
    }

    public int getCostOfBlock(BlockData block) {
        Slab slab;
        if (Tag.SLABS.isTagged((Keyed)block.getMaterial()) && block instanceof Slab && (slab = (Slab)block).getType() == Slab.Type.DOUBLE) {
            return 2;
        }
        return 1;
    }
}

