/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.area;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockCategories;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import io.papermc.paper.math.Position;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SignClickEvent;
import org.enginehub.craftbook.bukkit.events.SourcedBlockRedstoneEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.exception.InvalidMechanismException;
import org.enginehub.craftbook.mechanics.area.StoredBlockMechanic;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.BlockUtil;
import org.enginehub.craftbook.util.ConfigUtil;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.LocationUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.enginehub.craftbook.util.SignUtil;
import org.jspecify.annotations.Nullable;

public class Gate
extends StoredBlockMechanic {
    private boolean allowRedstone;
    private int columnLimit;
    private List<BaseBlock> blocks;
    private int columnHeight;
    private int searchRadius;

    public Gate(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    public boolean toggleGates(Block block, BukkitChangedSign sign, @Nullable Boolean close) throws InvalidMechanismException {
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        boolean foundGate = false;
        HashSet<GateColumn> visitedColumns = new HashSet<GateColumn>();
        Material type = this.getOrSetStoredType(sign.getBlock());
        for (int x1 = x - this.searchRadius; x1 <= x + this.searchRadius; ++x1) {
            for (int y1 = y - this.searchRadius; y1 <= y + this.searchRadius * 2; ++y1) {
                for (int z1 = z - this.searchRadius; z1 <= z + this.searchRadius; ++z1) {
                    if (!this.recurseColumn(sign, block.getWorld().getBlockAt(x1, y1, z1), type, visitedColumns, close)) continue;
                    foundGate = true;
                }
            }
        }
        return foundGate && !visitedColumns.isEmpty();
    }

    private boolean recurseColumn(BukkitChangedSign sign, Block block, Material expectedType, Set<GateColumn> visitedColumns, @Nullable Boolean close) throws InvalidMechanismException {
        if (this.columnLimit >= 0 && visitedColumns.size() > this.columnLimit || block.getType() != expectedType) {
            return false;
        }
        CraftBookPlugin.logDebugMessage("Found a possible gate column at " + block.getX() + ":" + block.getY() + ":" + block.getZ(), "gates.search");
        int x = block.getX();
        int z = block.getZ();
        GateColumn column = new GateColumn(block, expectedType);
        if (block.getWorld().getBlockAt(x, column.getStartingY() + 1, z).getType().isAir()) {
            return false;
        }
        if (visitedColumns.contains(column)) {
            return false;
        }
        visitedColumns.add(column);
        if (close == null) {
            close = block.getWorld().getBlockAt(x, column.getStartingY() - 1, z).getType() != expectedType;
        }
        CraftBookPlugin.logDebugMessage("Valid column at " + block.getX() + ":" + block.getY() + ":" + block.getZ() + " is being " + (close != false ? "closed" : "opened"), "gates.search");
        CraftBookPlugin.logDebugMessage("Column Top: " + column.getStartingY() + " End: " + column.getEndingY(), "gates.search");
        return this.toggleColumn(sign, column, close, visitedColumns);
    }

    private boolean toggleColumn(@Nullable BukkitChangedSign sign, GateColumn column, boolean close, Set<GateColumn> visitedColumns) throws InvalidMechanismException {
        BlockData item;
        Block block = column.getBlock();
        Material expectedType = column.getExpectedType();
        if (close) {
            item = column.getStartingPoint().getBlockData();
            if (item.getMaterial() != expectedType) {
                return false;
            }
        } else {
            item = Material.AIR.createBlockData();
        }
        CraftBookPlugin.logDebugMessage("Setting column at " + block.getX() + ":" + block.getY() + ":" + block.getZ() + " to " + String.valueOf(item), "gates.search");
        if (sign == null) {
            CraftBookPlugin.logDebugMessage("Invalid Sign!", "gates.search");
            return false;
        }
        Sign otherSign = null;
        Block ot = SignUtil.getNextSign(sign.getBlock(), PlainTextComponentSerializer.plainText().serialize(sign.getLine(1)), 4);
        if (ot != null) {
            otherSign = (Sign)ot.getState(false);
        }
        for (BlockVector3 bl : column.getRegion()) {
            Block blo = BukkitAdapter.adapt((World)block.getWorld(), (BlockVector3)bl).getBlock();
            Material bloType = blo.getType();
            if (!BlockUtil.isBlockReplacable(bloType) && bloType != expectedType) break;
            if (CraftBook.getInstance().getPlatform().getConfiguration().safeDestruction) {
                int blockCount = this.getStoredBlockCounts(sign.getSign(), otherSign);
                if (!close || blockCount > 0) {
                    boolean transactionSuccess = false;
                    if (!close && bloType == expectedType) {
                        transactionSuccess = this.addToStoredBlockCount(sign.getSign(), 1);
                    } else if (close && item.getMaterial() != bloType) {
                        transactionSuccess = this.takeFromStoredBlockCounts(1, sign.getSign(), otherSign);
                    }
                    if (transactionSuccess) {
                        blo.setBlockData(item, true);
                    }
                } else if (item.getMaterial() == expectedType) {
                    throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.gate.not-enough-blocks"));
                }
            } else {
                blo.setBlockData(item, true);
            }
            CraftBookPlugin.logDebugMessage("Set block " + bl.x() + ":" + bl.y() + ":" + bl.z() + " to " + String.valueOf(item), "gates.search");
            this.recurseColumn(sign, blo.getRelative(1, 0, 0), expectedType, visitedColumns, close);
            this.recurseColumn(sign, blo.getRelative(-1, 0, 0), expectedType, visitedColumns, close);
            this.recurseColumn(sign, blo.getRelative(0, 0, 1), expectedType, visitedColumns, close);
            this.recurseColumn(sign, blo.getRelative(0, 0, -1), expectedType, visitedColumns, close);
        }
        this.recurseColumn(sign, column.getStartingPoint().getRelative(1, 0, 0), expectedType, visitedColumns, close);
        this.recurseColumn(sign, column.getStartingPoint().getRelative(-1, 0, 0), expectedType, visitedColumns, close);
        this.recurseColumn(sign, column.getStartingPoint().getRelative(0, 0, 1), expectedType, visitedColumns, close);
        this.recurseColumn(sign, column.getStartingPoint().getRelative(0, 0, -1), expectedType, visitedColumns, close);
        this.recurseColumn(sign, column.getStartingPoint().getRelative(1, 1, 0), expectedType, visitedColumns, close);
        this.recurseColumn(sign, column.getStartingPoint().getRelative(-1, 1, 0), expectedType, visitedColumns, close);
        this.recurseColumn(sign, column.getStartingPoint().getRelative(0, 1, 1), expectedType, visitedColumns, close);
        this.recurseColumn(sign, column.getStartingPoint().getRelative(0, 1, -1), expectedType, visitedColumns, close);
        return true;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        if (!EventUtil.passesFilter((Event)event) || event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() == null) {
            return;
        }
        if (!this.isApplicableSign(event.getSign().getSign())) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.gate.use")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        try {
            Material gateType;
            Material heldItemType;
            if (CraftBook.getInstance().getPlatform().getConfiguration().safeDestruction && (heldItemType = event.getPlayer().getInventory().getItem(event.getHand()).getType()) != Material.AIR && (gateType = this.getOrSetStoredType(event.getClickedBlock())) == heldItemType) {
                if (!player.hasPermission("craftbook.gate.restock")) {
                    if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                        player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.gate.restock-permissions"));
                    }
                    return;
                }
                int heldAmount = event.getPlayer().getInventory().getItem(event.getHand()).getAmount();
                int amount = 1;
                if (event.getPlayer().isSneaking() && heldAmount >= 5) {
                    amount = 5;
                }
                this.addToStoredBlockCount(event.getSign().getSign(), amount);
                if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                    event.getPlayer().getInventory().getItem(event.getHand()).subtract(amount);
                }
                player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.gate.restock"));
                event.setCancelled(true);
                return;
            }
            event.setCancelled(true);
            if (this.toggleGates(event.getClickedBlock(), event.getSign(), null)) {
                player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.gate.toggle"));
            } else {
                player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.gate.not-found"));
            }
        }
        catch (InvalidMechanismException e) {
            player.printError(e.getRichMessage());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.allowRedstone || event.isMinor() || !EventUtil.passesFilter((Event)event) || !SignUtil.isSign(event.getBlock())) {
            return;
        }
        Sign bukkitSign = (Sign)event.getBlock().getState(false);
        if (!this.isApplicableSign(bukkitSign)) {
            return;
        }
        Side side = bukkitSign.getInteractableSideFor((Position)event.getSource().getLocation());
        BukkitChangedSign sign = BukkitChangedSign.create(bukkitSign, side);
        CraftBookPlugin.inst().getServer().getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
            try {
                this.toggleGates(event.getBlock(), sign, event.getNewCurrent() > 0);
            }
            catch (InvalidMechanismException invalidMechanismException) {
                // empty catch block
            }
        }, 2L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        String signLine1 = PlainTextComponentSerializer.plainText().serialize(event.line(1));
        if (!signLine1.equalsIgnoreCase("[Gate]")) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.gate.create")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.create-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            SignUtil.cancelSignChange(event);
            return;
        }
        event.line(1, (Component)Component.text((String)"[Gate]"));
        player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.gate.create"));
    }

    @Override
    public Block getBlockBase(Block sign) throws InvalidMechanismException {
        Block gateBlock = null;
        if (sign != null) {
            Material expectedType = this.getStoredType((Sign)sign.getState(false));
            ArrayDeque<Block> enumerationQueue = new ArrayDeque<Block>();
            HashSet<Block> visited = new HashSet<Block>();
            enumerationQueue.add(sign);
            visited.add(sign);
            block0: while (!enumerationQueue.isEmpty()) {
                Block currentOrigin = (Block)enumerationQueue.poll();
                if (Math.abs(currentOrigin.getX() - sign.getX()) >= this.searchRadius || Math.abs(currentOrigin.getY() - sign.getY()) >= this.searchRadius * 2 || Math.abs(currentOrigin.getZ() - sign.getZ()) >= this.searchRadius) continue;
                for (BlockFace face : LocationUtil.getDirectFaces()) {
                    Block neighbor = currentOrigin.getRelative(face);
                    if (!visited.add(neighbor)) continue;
                    BlockData neighborData = neighbor.getBlockData();
                    if (expectedType != null) {
                        if (neighborData.getMaterial() == expectedType) {
                            gateBlock = neighbor;
                            break block0;
                        }
                    } else if (Blocks.containsFuzzy(this.blocks, (BlockStateHolder)BukkitAdapter.adapt((BlockData)neighborData))) {
                        gateBlock = neighbor;
                        break block0;
                    }
                    enumerationQueue.add(neighbor);
                }
            }
        }
        if (gateBlock == null) {
            throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.gate.unusable-material"));
        }
        return gateBlock;
    }

    @Override
    public boolean isApplicableSign(String line) {
        return line.equalsIgnoreCase("[Gate]");
    }

    public List<String> getDefaultBlocks() {
        ArrayList<String> materials = new ArrayList<String>();
        materials.addAll(ConfigUtil.getIdsFromCategory(BlockCategories.FENCES));
        materials.add(BlockTypes.IRON_BARS.id());
        materials.add(BlockTypes.GLASS_PANE.id());
        return materials;
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("allow-redstone", "Allows the gate mechanic to be toggled via redstone.");
        this.allowRedstone = config.getBoolean("allow-redstone", true);
        config.setComment("max-columns", "The maximum number of columns that a gate can toggle. -1 for no limit.");
        this.columnLimit = config.getInt("max-columns", 14);
        config.setComment("blocks", "The list of blocks that a gate can use.");
        this.blocks = BlockParser.getBlocks(config.getStringList("blocks", this.getDefaultBlocks().stream().sorted(String::compareToIgnoreCase).toList()), true);
        config.setComment("max-column-height", "The max height of a column.");
        this.columnHeight = config.getInt("max-column-height", 12);
        config.setComment("search-radius", "The radius around the sign the gate checks for fences in. Note: This is doubled upwards.");
        this.searchRadius = config.getInt("search-radius", 3);
    }

    protected class GateColumn {
        private final Block block;
        private final Material expectedType;
        private int minY = Integer.MIN_VALUE;
        private int maxY = Integer.MAX_VALUE;

        public GateColumn(Block block, Material expectedType) {
            this.block = block;
            this.expectedType = expectedType;
        }

        public Block getStartingPoint() {
            return this.block.getWorld().getBlockAt(this.block.getX(), this.getStartingY(), this.block.getZ());
        }

        public Block getEndingPoint() {
            return this.block.getWorld().getBlockAt(this.block.getX(), this.getEndingY(), this.block.getZ());
        }

        public int getStartingY() {
            if (this.maxY == Integer.MAX_VALUE) {
                Material currentBlockType;
                int remainingColumnHeight;
                int max = Math.min(this.block.getWorld().getMaxHeight() - 1, this.block.getY() + remainingColumnHeight);
                int y1 = this.block.getY() + 1;
                for (remainingColumnHeight = Gate.this.columnHeight; y1 <= max && remainingColumnHeight > 0 && (currentBlockType = this.block.getWorld().getBlockAt(this.block.getX(), y1, this.block.getZ()).getType()) == this.expectedType; --remainingColumnHeight) {
                    this.maxY = y1++;
                }
                if (this.maxY == Integer.MAX_VALUE) {
                    this.maxY = this.block.getY();
                }
            }
            return this.maxY;
        }

        public int getEndingY() {
            if (this.minY == Integer.MIN_VALUE) {
                Material currentBlockType;
                int remainingColumnHeight;
                int min = Math.max(this.block.getWorld().getMinHeight(), this.block.getY() - remainingColumnHeight);
                int y = this.block.getY();
                for (remainingColumnHeight = Gate.this.columnHeight; y >= min && remainingColumnHeight > 0 && (BlockUtil.isBlockReplacable(currentBlockType = this.block.getWorld().getBlockAt(this.block.getX(), y, this.block.getZ()).getType()) || currentBlockType == this.expectedType); --remainingColumnHeight) {
                    this.minY = y--;
                }
                if (this.minY == Integer.MIN_VALUE) {
                    this.minY = this.block.getY();
                }
            }
            return this.minY;
        }

        public int getX() {
            return this.block.getX();
        }

        public int getZ() {
            return this.block.getZ();
        }

        public Block getBlock() {
            return this.block;
        }

        public Material getExpectedType() {
            return this.expectedType;
        }

        public CuboidRegion getRegion() {
            return new CuboidRegion(BukkitAdapter.adapt((Location)this.getStartingPoint().getRelative(0, -1, 0).getLocation()).toVector().toBlockPoint(), BukkitAdapter.adapt((Location)this.getEndingPoint().getLocation()).toVector().toBlockPoint());
        }

        public boolean equals(Object o) {
            return o instanceof GateColumn && ((GateColumn)o).getX() == this.getX() && ((GateColumn)o).getZ() == this.getZ() && this.block.getWorld().getName().equals(((GateColumn)o).block.getWorld().getName());
        }

        public int hashCode() {
            return Objects.hash(this.getX(), this.getZ());
        }
    }
}

