/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.area;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockCategories;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import io.papermc.paper.math.Position;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SignClickEvent;
import org.enginehub.craftbook.bukkit.events.SourcedBlockRedstoneEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.exception.InvalidMechanismException;
import org.enginehub.craftbook.mechanics.area.CuboidToggleMechanic;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.BlockUtil;
import org.enginehub.craftbook.util.ConfigUtil;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.enginehub.craftbook.util.SignUtil;
import org.jspecify.annotations.Nullable;

public class Door
extends CuboidToggleMechanic {
    private boolean allowRedstone;
    private int maxLength;
    private int maxWidth;
    private List<BaseBlock> blocks;

    public Door(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        String signLine1 = PlainTextComponentSerializer.plainText().serialize(event.line(1));
        if (!(signLine1.equalsIgnoreCase("[door]") || signLine1.equalsIgnoreCase("[door up]") || signLine1.equalsIgnoreCase("[door down]"))) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.door.create")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.create-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            SignUtil.cancelSignChange(event);
            return;
        }
        if (signLine1.equalsIgnoreCase("[door]")) {
            event.line(1, (Component)Component.text((String)"[Door]"));
            player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.end-create"));
        } else if (signLine1.equalsIgnoreCase("[door up]")) {
            event.line(1, (Component)Component.text((String)"[Door Up]"));
            player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.create"));
        } else if (signLine1.equalsIgnoreCase("[door down]")) {
            event.line(1, (Component)Component.text((String)"[Door Down]"));
            player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.create"));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        block14: {
            if (!EventUtil.passesFilter((Event)event) || event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() == null) {
                return;
            }
            if (!this.isApplicableSign(event.getSign().getSign())) {
                return;
            }
            CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
            if (!player.hasPermission("craftbook.door.use")) {
                if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                    player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
                }
                return;
            }
            if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
                if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                    player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
                }
                return;
            }
            try {
                Material bridgeType;
                Material heldItemType;
                if (CraftBook.getInstance().getPlatform().getConfiguration().safeDestruction && (heldItemType = event.getPlayer().getInventory().getItem(event.getHand()).getType()) != Material.AIR && heldItemType == (bridgeType = this.getOrSetStoredType(event.getClickedBlock()))) {
                    if (!player.hasPermission("craftbook.door.restock")) {
                        if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                            player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.restock-permissions"));
                        }
                        return;
                    }
                    int heldAmount = event.getPlayer().getInventory().getItem(event.getHand()).getAmount();
                    int amount = 1;
                    if (event.getPlayer().isSneaking() && heldAmount >= 5) {
                        amount = 5;
                    }
                    this.addToStoredBlockCount(event.getSign().getSign(), amount);
                    if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                        event.getPlayer().getInventory().getItem(event.getHand()).subtract(amount);
                    }
                    player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.restock"));
                    event.setCancelled(true);
                    return;
                }
                event.setCancelled(true);
                if (this.flipState(event.getClickedBlock(), event.getSign())) {
                    player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.toggle"));
                }
            }
            catch (InvalidMechanismException e) {
                if (e.getRichMessage() == null) break block14;
                player.printError(e.getRichMessage());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.allowRedstone || event.isMinor() || !EventUtil.passesFilter((Event)event) || !SignUtil.isSign(event.getBlock())) {
            return;
        }
        Sign bukkitSign = (Sign)event.getBlock().getState(false);
        if (!this.isApplicableSign(bukkitSign)) {
            return;
        }
        Side side = bukkitSign.getInteractableSideFor((Position)event.getSource().getLocation());
        BukkitChangedSign sign = BukkitChangedSign.create(bukkitSign, side);
        Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
            try {
                this.flipState(event.getBlock(), sign);
            }
            catch (InvalidMechanismException invalidMechanismException) {
                // empty catch block
            }
        }, 2L);
    }

    public boolean flipState(Block trigger, BukkitChangedSign sign) throws InvalidMechanismException {
        Block distalBaseCenter;
        if (!SignUtil.isCardinal(trigger)) {
            return false;
        }
        Block proximalBaseCenter = this.getBlockBase(trigger);
        BlockData proximalBaseData = proximalBaseCenter.getBlockData();
        Material doorType = this.getOrSetStoredType(trigger);
        if (proximalBaseData.getMaterial() != doorType) {
            throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.different-materials"));
        }
        Block farSide = this.getFarSign(trigger);
        if (farSide == null || farSide.getType() != trigger.getType()) {
            throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.missing-other-sign"));
        }
        String line1 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(1));
        if (line1.equalsIgnoreCase("[Door Up]")) {
            distalBaseCenter = farSide.getRelative(BlockFace.DOWN);
        } else if (line1.equalsIgnoreCase("[Door Down]")) {
            distalBaseCenter = farSide.getRelative(BlockFace.UP);
        } else {
            throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.missing-other-sign"));
        }
        if (!distalBaseCenter.getBlockData().matches(proximalBaseData)) {
            throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.different-materials"));
        }
        CuboidRegion toggle = this.getCuboidArea(trigger, proximalBaseCenter, distalBaseCenter);
        Material hingeType = line1.equals("[Door Up]") ? proximalBaseCenter.getRelative(BlockFace.UP).getType() : proximalBaseCenter.getRelative(BlockFace.DOWN).getType();
        if (BlockUtil.isBlockReplacable(hingeType) && proximalBaseData.getMaterial() != hingeType) {
            boolean closeSuccess = this.close(sign.getSign(), (Sign)farSide.getState(false), proximalBaseData, toggle);
            if (!closeSuccess) {
                throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.not-enough-blocks"));
            }
            return true;
        }
        return this.open(sign.getSign(), proximalBaseData, toggle);
    }

    @Override
    public @Nullable Block getFarSign(Block nearSign) {
        Block otherSide = null;
        BlockFace direction = null;
        Sign bukkitSign = (Sign)nearSign.getState(false);
        for (Side side : Side.values()) {
            String line1 = PlainTextComponentSerializer.plainText().serialize(bukkitSign.getSide(side).line(1));
            if (line1.equals("[Door Up]")) {
                direction = BlockFace.UP;
            } else if (line1.equals("[Door Down]")) {
                direction = BlockFace.DOWN;
            }
            if (direction == null) continue;
            otherSide = nearSign.getRelative(direction);
            break;
        }
        if (otherSide == null) {
            return null;
        }
        for (int i = 0; i <= this.maxLength; ++i) {
            if (SignUtil.isSign(otherSide)) {
                Sign otherSign = (Sign)otherSide.getState(false);
                for (Side side : Side.values()) {
                    String line1 = PlainTextComponentSerializer.plainText().serialize(otherSign.getSide(side).line(1));
                    if (!this.isApplicableSign(line1) && !"[Door]".equals(line1)) continue;
                    return otherSide;
                }
            }
            otherSide = otherSide.getRelative(direction);
        }
        return otherSide;
    }

    @Override
    public Block getBlockBase(Block sign) throws InvalidMechanismException {
        Block proximalBaseCenter = null;
        Sign bukkitSign = (Sign)sign.getState(false);
        for (Side side : Side.values()) {
            String line1 = PlainTextComponentSerializer.plainText().serialize(bukkitSign.getSide(side).line(1));
            if (line1.equalsIgnoreCase("[Door Up]")) {
                proximalBaseCenter = sign.getRelative(BlockFace.UP);
                break;
            }
            if (!line1.equalsIgnoreCase("[Door Down]")) continue;
            proximalBaseCenter = sign.getRelative(BlockFace.DOWN);
            break;
        }
        if (proximalBaseCenter == null) {
            throw new IllegalStateException("Sign passed as a door sign is not a door sign");
        }
        if (Blocks.containsFuzzy(this.blocks, (BlockStateHolder)BukkitAdapter.adapt((BlockData)proximalBaseCenter.getBlockData()))) {
            return proximalBaseCenter;
        }
        throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.unusable-material"));
    }

    @Override
    public CuboidRegion getCuboidArea(Block trigger, Block proximalBaseCenter, Block distalBaseCenter) throws InvalidMechanismException {
        Material proximalOffsetType;
        int i;
        double distance = proximalBaseCenter.getLocation().distanceSquared(distalBaseCenter.getLocation());
        if (distance <= 4.0) {
            throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.too-short"));
        }
        Material expectedType = this.getOrSetStoredType(trigger);
        CuboidRegion toggle = new CuboidRegion(BukkitAdapter.asBlockVector((Location)proximalBaseCenter.getLocation()), BukkitAdapter.asBlockVector((Location)distalBaseCenter.getLocation()));
        if (distalBaseCenter.getType() != proximalBaseCenter.getType()) {
            throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.different-materials"));
        }
        for (i = 1; i < this.maxWidth && (proximalOffsetType = proximalBaseCenter.getRelative(SignUtil.getLeft(trigger), i).getType()) == expectedType; ++i) {
            if (distalBaseCenter.getRelative(SignUtil.getLeft(trigger), i).getType() != proximalOffsetType) {
                throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.different-materials"));
            }
            toggle.expand(new BlockVector3[]{BlockUtil.toVector(SignUtil.getLeft(trigger)), BlockVector3.ZERO});
        }
        for (i = 1; i < this.maxWidth && (proximalOffsetType = proximalBaseCenter.getRelative(SignUtil.getRight(trigger), i).getType()) == expectedType; ++i) {
            if (distalBaseCenter.getRelative(SignUtil.getRight(trigger), i).getType() != proximalOffsetType) {
                throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.door.different-materials"));
            }
            toggle.expand(new BlockVector3[]{BlockUtil.toVector(SignUtil.getRight(trigger)), BlockVector3.ZERO});
        }
        toggle.contract(new BlockVector3[]{BlockUtil.toVector(BlockFace.UP), BlockUtil.toVector(BlockFace.DOWN)});
        return toggle;
    }

    @Override
    public boolean isApplicableSign(String line) {
        return line.equals("[Door Up]") || line.equals("[Door Down]");
    }

    public List<String> getDefaultBlocks() {
        ArrayList<String> materials = new ArrayList<String>();
        materials.add(BlockTypes.COBBLESTONE.id());
        materials.add(BlockTypes.GLASS.id());
        materials.addAll(ConfigUtil.getIdsFromCategory(BlockCategories.PLANKS));
        materials.addAll(ConfigUtil.getIdsFromCategory(BlockCategories.SLABS));
        return materials;
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        super.loadFromConfiguration(config);
        config.setComment("allow-redstone", "Allow doors to be toggled via redstone.");
        this.allowRedstone = config.getBoolean("allow-redstone", true);
        config.setComment("max-height", "The maximum height of a door.");
        this.maxLength = config.getInt("max-height", 30);
        config.setComment("max-width", "Max width either side. 5 = 11, 1 in middle, 5 on either side");
        this.maxWidth = config.getInt("max-width", 5);
        config.setComment("blocks", "A list of blocks that a door can be made out of.");
        this.blocks = BlockParser.getBlocks(config.getStringList("blocks", this.getDefaultBlocks().stream().sorted(String::compareToIgnoreCase).toList()), true);
    }
}

