/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.area;

import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.exception.InvalidMechanismException;
import org.enginehub.craftbook.mechanics.area.StoredBlockMechanic;
import org.enginehub.craftbook.util.BlockUtil;
import org.jspecify.annotations.Nullable;

public abstract class CuboidToggleMechanic
extends StoredBlockMechanic {
    public CuboidToggleMechanic(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    public abstract @Nullable Block getFarSign(Block var1);

    public abstract CuboidRegion getCuboidArea(Block var1, Block var2, Block var3) throws InvalidMechanismException;

    public boolean open(Sign sign, BlockData blockData, CuboidRegion toggle) {
        for (BlockVector3 bv : toggle) {
            Block checkBlock = sign.getWorld().getBlockAt(bv.x(), bv.y(), bv.z());
            BlockData checkType = checkBlock.getBlockData();
            if (checkType.getMaterial() != blockData.getMaterial() && !BlockUtil.isBlockReplacable(checkType.getMaterial())) continue;
            if (CraftBook.getInstance().getPlatform().getConfiguration().safeDestruction && checkType.getMaterial() == blockData.getMaterial()) {
                this.addToStoredBlockCount(sign, this.getCostOfBlock(checkType));
            }
            checkBlock.setType(Material.AIR);
        }
        return true;
    }

    public boolean close(Sign sign, Sign farSide, BlockData blockData, CuboidRegion toggle) {
        for (BlockVector3 bv : toggle) {
            Block b = sign.getWorld().getBlockAt(bv.x(), bv.y(), bv.z());
            if (!BlockUtil.isBlockReplacable(b.getType())) continue;
            if (CraftBook.getInstance().getPlatform().getConfiguration().safeDestruction) {
                if (this.getStoredBlockCounts(sign, farSide) > 0) {
                    b.setBlockData(blockData);
                    this.takeFromStoredBlockCounts(this.getCostOfBlock(blockData), sign, farSide);
                    continue;
                }
                return false;
            }
            b.setBlockData(blockData);
        }
        return true;
    }
}

