/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.area;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockCategories;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SignClickEvent;
import org.enginehub.craftbook.bukkit.events.SourcedBlockRedstoneEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.exception.InvalidMechanismException;
import org.enginehub.craftbook.mechanics.area.CuboidToggleMechanic;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.BlockUtil;
import org.enginehub.craftbook.util.ConfigUtil;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.enginehub.craftbook.util.SignUtil;

public class Bridge
extends CuboidToggleMechanic {
    private boolean allowRedstone;
    private int maxLength;
    private int maxWidth;
    private List<BaseBlock> blocks;

    public Bridge(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        String signLine1 = PlainTextComponentSerializer.plainText().serialize(event.line(1));
        if (!signLine1.equalsIgnoreCase("[bridge]") && !signLine1.equalsIgnoreCase("[bridge end]")) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.bridge.create")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.create-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            SignUtil.cancelSignChange(event);
            return;
        }
        if (signLine1.equalsIgnoreCase("[bridge]")) {
            event.line(1, (Component)Component.text((String)"[Bridge]"));
            player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.bridge.create"));
        } else if (signLine1.equalsIgnoreCase("[bridge end]")) {
            event.line(1, (Component)Component.text((String)"[Bridge End]"));
            player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.bridge.end-create"));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        block14: {
            if (!EventUtil.passesFilter((Event)event) || event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() == null) {
                return;
            }
            if (!this.isApplicableSign(event.getSign().getSign())) {
                return;
            }
            CraftBookPlayer player = event.getWrappedPlayer();
            if (!player.hasPermission("craftbook.bridge.use")) {
                if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                    player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
                }
                return;
            }
            if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
                if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                    player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
                }
                return;
            }
            try {
                Material bridgeType;
                Material heldItemType;
                if (CraftBook.getInstance().getPlatform().getConfiguration().safeDestruction && (heldItemType = event.getPlayer().getInventory().getItem(event.getHand()).getType()) != Material.AIR && (bridgeType = this.getOrSetStoredType(event.getClickedBlock())) == heldItemType) {
                    if (!player.hasPermission("craftbook.bridge.restock")) {
                        if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                            player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.bridge.restock-permissions"));
                        }
                        return;
                    }
                    int heldAmount = event.getPlayer().getInventory().getItem(event.getHand()).getAmount();
                    int amount = 1;
                    if (event.getPlayer().isSneaking() && heldAmount >= 5) {
                        amount = 5;
                    }
                    this.addToStoredBlockCount(event.getSign().getSign(), amount);
                    if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                        event.getPlayer().getInventory().getItem(event.getHand()).subtract(amount);
                    }
                    player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.bridge.restock"));
                    event.setCancelled(true);
                    return;
                }
                event.setCancelled(true);
                if (this.flipState(event.getClickedBlock())) {
                    player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.bridge.toggle"));
                }
            }
            catch (InvalidMechanismException e) {
                if (e.getRichMessage() == null) break block14;
                player.printError(e.getRichMessage());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.allowRedstone || event.isMinor() || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!SignUtil.isSign(event.getBlock()) || !this.isApplicableSign((Sign)event.getBlock().getState(false))) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
            try {
                this.flipState(event.getBlock());
            }
            catch (InvalidMechanismException invalidMechanismException) {
                // empty catch block
            }
        }, 2L);
    }

    @Override
    public Block getBlockBase(Block sign) throws InvalidMechanismException {
        Block proximalBaseCenter = sign.getRelative(BlockFace.UP);
        if (sign.getY() < sign.getWorld().getMaxHeight() - 1 && Blocks.containsFuzzy(this.blocks, (BlockStateHolder)BukkitAdapter.adapt((BlockData)proximalBaseCenter.getBlockData()))) {
            return proximalBaseCenter;
        }
        proximalBaseCenter = sign.getRelative(BlockFace.DOWN);
        if (sign.getY() > sign.getWorld().getMinHeight() && Blocks.containsFuzzy(this.blocks, (BlockStateHolder)BukkitAdapter.adapt((BlockData)proximalBaseCenter.getBlockData()))) {
            return proximalBaseCenter;
        }
        proximalBaseCenter = sign.getRelative(SignUtil.getBack(sign));
        if (Blocks.containsFuzzy(this.blocks, (BlockStateHolder)BukkitAdapter.adapt((BlockData)proximalBaseCenter.getBlockData()))) {
            return proximalBaseCenter;
        }
        throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.bridge.unusable-material"));
    }

    @Override
    public Block getFarSign(Block nearSign) {
        BlockFace dir = SignUtil.getBack(nearSign);
        Block farSide = nearSign.getRelative(dir);
        Material nearType = nearSign.getType();
        for (int i = 0; i <= this.maxLength; ++i) {
            if (farSide.getType() == nearType) {
                Sign bukkitSign = (Sign)farSide.getState(false);
                boolean found = false;
                for (Side side : Side.values()) {
                    String otherSignText = bukkitSign.getSide(side).getLine(1);
                    if (!"[Bridge]".equalsIgnoreCase(otherSignText) && !"[Bridge End]".equalsIgnoreCase(otherSignText)) continue;
                    found = true;
                    break;
                }
                if (found) break;
            }
            farSide = farSide.getRelative(dir);
        }
        return farSide;
    }

    @Override
    public CuboidRegion getCuboidArea(Block trigger, Block proximalBaseCenter, Block distalBaseCenter) throws InvalidMechanismException {
        Material proximalOffsetType;
        int i;
        double distance = proximalBaseCenter.getLocation().distanceSquared(distalBaseCenter.getLocation());
        if (distance <= 4.0) {
            throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.bridge.too-short"));
        }
        CuboidRegion toggle = new CuboidRegion(BukkitAdapter.asBlockVector((Location)proximalBaseCenter.getLocation()), BukkitAdapter.asBlockVector((Location)distalBaseCenter.getLocation()));
        Material expectedType = this.getOrSetStoredType(trigger);
        if (distalBaseCenter.getType() != proximalBaseCenter.getType()) {
            throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.bridge.different-materials"));
        }
        for (i = 1; i < this.maxWidth && (proximalOffsetType = proximalBaseCenter.getRelative(SignUtil.getLeft(trigger), i).getType()) == expectedType; ++i) {
            if (distalBaseCenter.getRelative(SignUtil.getLeft(trigger), i).getType() != proximalOffsetType) {
                throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.bridge.different-materials"));
            }
            toggle.expand(new BlockVector3[]{BlockUtil.toVector(SignUtil.getLeft(trigger)), BlockVector3.ZERO});
        }
        for (i = 1; i < this.maxWidth && (proximalOffsetType = proximalBaseCenter.getRelative(SignUtil.getRight(trigger), i).getType()) == expectedType; ++i) {
            if (distalBaseCenter.getRelative(SignUtil.getRight(trigger), i).getType() != proximalOffsetType) {
                throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.bridge.different-materials"));
            }
            toggle.expand(new BlockVector3[]{BlockUtil.toVector(SignUtil.getRight(trigger)), BlockVector3.ZERO});
        }
        toggle.contract(new BlockVector3[]{BlockUtil.toVector(SignUtil.getBack(trigger)), BlockUtil.toVector(SignUtil.getFront(trigger))});
        return toggle;
    }

    public boolean flipState(Block trigger) throws InvalidMechanismException {
        Block distalBaseCenter;
        if (!SignUtil.isCardinal(trigger)) {
            return false;
        }
        Block proximalBaseCenter = this.getBlockBase(trigger);
        BlockData proximalBaseData = proximalBaseCenter.getBlockData();
        Material bridgeType = this.getOrSetStoredType(trigger);
        if (bridgeType != proximalBaseData.getMaterial()) {
            throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.bridge.different-materials"));
        }
        Block farSide = this.getFarSign(trigger);
        if (farSide == null || farSide.getType() != trigger.getType()) {
            throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.bridge.missing-other-sign"));
        }
        BlockFace face = trigger.getFace(proximalBaseCenter);
        if (face != null && face != BlockFace.UP && face != BlockFace.DOWN) {
            face = face.getOppositeFace();
        }
        if (!(distalBaseCenter = farSide.getRelative(face)).getBlockData().matches(proximalBaseData)) {
            throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.bridge.different-materials"));
        }
        CuboidRegion toggle = this.getCuboidArea(trigger, proximalBaseCenter, distalBaseCenter);
        Material hingeType = proximalBaseCenter.getRelative(SignUtil.getBack(trigger)).getType();
        if (BlockUtil.isBlockReplacable(hingeType) && proximalBaseData.getMaterial() != hingeType) {
            boolean closeSuccess = this.close((Sign)trigger.getState(false), (Sign)farSide.getState(false), proximalBaseData, toggle);
            if (!closeSuccess) {
                throw new InvalidMechanismException((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.bridge.not-enough-blocks"));
            }
            return true;
        }
        return this.open((Sign)trigger.getState(false), proximalBaseData, toggle);
    }

    @Override
    public boolean isApplicableSign(String line) {
        return line.equals("[Bridge]");
    }

    private List<String> getDefaultBlocks() {
        ArrayList<String> materials = new ArrayList<String>();
        materials.add(BlockTypes.COBBLESTONE.id());
        materials.add(BlockTypes.GLASS.id());
        materials.addAll(ConfigUtil.getIdsFromCategory(BlockCategories.PLANKS));
        materials.addAll(ConfigUtil.getIdsFromCategory(BlockCategories.SLABS));
        return materials;
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        super.loadFromConfiguration(config);
        config.setComment("allow-redstone", "Allow bridges to be toggled via redstone.");
        this.allowRedstone = config.getBoolean("allow-redstone", true);
        config.setComment("max-length", "Maximum length of a bridge.");
        this.maxLength = config.getInt("max-length", 30);
        config.setComment("max-width", "Max width either side. 5 = 11, 1 in middle, 5 on either side.");
        this.maxWidth = config.getInt("max-width", 5);
        config.setComment("blocks", "List of blocks that a bridge can be made out of.");
        this.blocks = BlockParser.getBlocks(config.getStringList("blocks", this.getDefaultBlocks().stream().sorted(String::compareToIgnoreCase).toList()), true);
    }
}

