/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.TernaryState;

public abstract class XPStorer
extends AbstractCraftBookMechanic {
    protected boolean requireBottle;
    protected boolean allowOffHand;
    protected int bottleXpRequirement;
    protected int bottleXpOverride;
    protected String bottleExtraData;
    protected BaseBlock block;
    protected TernaryState allowSneaking;
    protected boolean radiusMode;
    protected int maxRadius;

    public XPStorer(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("require-bottle", "Requires the player to be holding a glass bottle to use.");
        this.requireBottle = config.getBoolean("require-bottle", true);
        config.setComment("allow-offhand", "Allows XP bottles in the off hand to work.");
        this.allowOffHand = config.getBoolean("allow-offhand", true);
        config.setComment("bottle-xp-requirement", "Sets the amount of XP points required per each bottle.");
        this.bottleXpRequirement = config.getInt("bottle-xp-requirement", 16);
        config.setComment("bottle-xp-override", "Set the amount of XP points that each bottle provides on usage (-1 to use MC behaviour).");
        this.bottleXpOverride = config.getInt("bottle-xp-override", -1);
        config.setComment("bottle-extra-data", "Extra data to apply to the item, using /give command syntax.");
        this.bottleExtraData = config.getString("bottle-extra-data", "minecraft:experience_bottle");
        config.setComment("block", "The block that is an XP Storer.");
        this.block = BlockParser.getBlock(config.getString("block", BlockTypes.SPAWNER.id()), true);
        config.setComment("allow-sneaking", "Sets how the player must be sneaking in order to use the XP Storer.");
        this.allowSneaking = TernaryState.parseTernaryState(config.getString("allow-sneaking", TernaryState.FALSE.toString()));
        config.setComment("radius-mode", "Allows XP Storer mechanics with a sign attached to work in a radius.");
        this.radiusMode = config.getBoolean("radius-mode", false);
        config.setComment("max-radius", "The max radius when using radius-mode.");
        this.maxRadius = config.getInt("max-radius", 5);
    }
}

