/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics;

import com.sk89q.util.yaml.YAMLProcessor;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;

public abstract class Teleporter
extends AbstractCraftBookMechanic {
    protected boolean requireSign;
    protected int maxRange;
    protected boolean buttonEnabled;

    public Teleporter(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("require-sign", "Require a sign to be at the destination of the teleportation.");
        this.requireSign = config.getBoolean("require-sign", false);
        config.setComment("max-range", "The maximum distance between the start and end of a teleporter. Set to 0 for infinite.");
        this.maxRange = config.getInt("max-range", 0);
        config.setComment("enable-buttons", "Allow teleporters to be used by a button on the other side of the block.");
        this.buttonEnabled = config.getBoolean("enable-buttons", true);
    }
}

