/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.util.BlockParser;

public abstract class Snow
extends AbstractCraftBookMechanic {
    protected static final double SNOW_MELTING_TEMPERATURE = 0.05;
    protected static final double SNOW_FORM_TEMPERATURE = 0.15;
    protected boolean snowPiling;
    protected boolean trample;
    protected boolean partialTrample;
    protected boolean snowballPlacement;
    protected boolean slowdown;
    protected boolean dispersionMode;
    protected boolean pileHigh;
    protected int maxPileHeight;
    protected boolean jumpTrample;
    protected List<BaseBlock> dispersionReplacables;
    protected int dispersionTickSpeed;
    protected boolean freezeWater;
    protected boolean meltSunlight;
    protected boolean meltPartial;

    public Snow(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    private static List<String> getDefaultReplacables() {
        return List.of(BlockTypes.DEAD_BUSH.id(), BlockTypes.SHORT_GRASS.id(), BlockTypes.FIRE.id(), BlockTypes.FERN.id());
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("piling", "Enables the piling feature of the Snow mechanic.");
        this.snowPiling = config.getBoolean("piling", false);
        config.setComment("trample", "Enables the trampling feature of the Snow mechanic.");
        this.trample = config.getBoolean("trample", false);
        config.setComment("partial-trample-only", "If trampling is enabled, only trample it down to the smallest snow.");
        this.partialTrample = config.getBoolean("partial-trample-only", false);
        config.setComment("jump-trample", "Require jumping to trample snow.");
        this.jumpTrample = config.getBoolean("jump-trample", false);
        config.setComment("place-snowball", "Allow snowballs to create snow when they land.");
        this.snowballPlacement = config.getBoolean("place-snowball", false);
        config.setComment("slowdown", "Slows down entities as they walk through thick snow.");
        this.slowdown = config.getBoolean("slowdown", false);
        config.setComment("dispersion", "Enable realistic snow dispersion.");
        this.dispersionMode = config.getBoolean("dispersion", false);
        config.setComment("high-piling", "Allow piling above the 1 block height.");
        this.pileHigh = config.getBoolean("high-piling", false);
        config.setComment("max-pile-height", "The maximum piling height of high piling snow.");
        this.maxPileHeight = config.getInt("max-pile-height", 3);
        config.setComment("replaceable-blocks", "A list of blocks that can be replaced by snow dispersion.");
        this.dispersionReplacables = BlockParser.getBlocks(config.getStringList("replaceable-blocks", Snow.getDefaultReplacables()), true);
        config.setComment("dispersion-tick-speed", "The speed at which dispersion actions are run");
        this.dispersionTickSpeed = config.getInt("dispersion-tick-speed", 20);
        config.setComment("freeze-water", "Should snow freeze water?");
        this.freezeWater = config.getBoolean("freeze-water", false);
        config.setComment("melt-in-sunlight", "Enables snow to melt in sunlight.");
        this.meltSunlight = config.getBoolean("melt-in-sunlight", false);
        config.setComment("partial-melt-only", "If melt in sunlight is enabled, only melt it down to the smallest snow similar to vanilla MC.");
        this.meltPartial = config.getBoolean("partial-melt-only", true);
    }
}

