/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;

public abstract class RedstoneFire
extends AbstractCraftBookMechanic {
    private boolean enableNetherrack;
    private boolean enableSoulSoil;

    public RedstoneFire(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    protected boolean doesAffectBlock(BlockType type) {
        return this.enableNetherrack && type == BlockTypes.NETHERRACK || this.enableSoulSoil && type == BlockTypes.SOUL_SOIL;
    }

    protected BlockType getFireForBlock(BlockType type) {
        if (type == BlockTypes.NETHERRACK) {
            return BlockTypes.FIRE;
        }
        if (type == BlockTypes.SOUL_SOIL) {
            return BlockTypes.SOUL_FIRE;
        }
        throw new RuntimeException("Tried to place fire on an unsupported block. Please report this error to CraftBook");
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("enable-netherrack", "Whether the mechanic should affect Netherrack.");
        this.enableNetherrack = config.getBoolean("enable-netherrack", true);
        config.setComment("enable-soul-soil", "Whether the mechanic should affect Soul Soil.");
        this.enableSoulSoil = config.getBoolean("enable-soul-soil", true);
    }
}

