/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.exception.MechanicInitializationException;
import org.enginehub.craftbook.util.TernaryState;
import org.jspecify.annotations.Nullable;

public abstract class ReadableBookshelf
extends AbstractCraftBookMechanic {
    public @Nullable List<String> lines;
    protected boolean allowHoldingBlock;
    protected TernaryState allowSneaking;

    public ReadableBookshelf(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() throws MechanicInitializationException {
        try {
            List<String> lines = Files.readAllLines(CraftBook.getInstance().getPlatform().getWorkingDirectory().resolve("books.txt"), StandardCharsets.UTF_8);
            this.lines = List.copyOf(lines);
            if (this.lines.isEmpty()) {
                throw new MechanicInitializationException(this.getMechanicType(), (Component)TranslatableComponent.of((String)"craftbook.readablebookshelf.empty"));
            }
        }
        catch (IOException e) {
            throw new MechanicInitializationException(this.getMechanicType(), (Component)TranslatableComponent.of((String)"craftbook.readablebookshelf.failed-to-read"), e);
        }
    }

    @Override
    public void disable() {
        this.lines = null;
    }

    public void read(CraftBookPlayer player) {
        player.printInfo(((TextComponent)((TextComponent)TextComponent.empty().append((Component)TranslatableComponent.of((String)"craftbook.readablebookshelf.read"))).append((Component)TextComponent.newline())).append((Component)this.getBookLine()));
    }

    private TextComponent getBookLine() {
        if (this.lines == null) {
            return TextComponent.of((String)"No books available", (TextColor)TextColor.RED);
        }
        return TextComponent.of((String)this.lines.get(ThreadLocalRandom.current().nextInt(this.lines.size())), (TextColor)TextColor.WHITE);
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("allow-sneaking", "Enable reading while sneaking.");
        this.allowSneaking = TernaryState.parseTernaryState(config.getString("allow-sneaking", TernaryState.FALSE.toString()));
        config.setComment("allow-holding-block", "Allow bookshelves to work when the player is holding a block.");
        this.allowHoldingBlock = config.getBoolean("allow-holding-block", false);
    }
}

