/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.util.ItemParser;

public abstract class LightStone
extends AbstractCraftBookMechanic {
    protected ItemType item;
    protected boolean actionBar;

    public LightStone(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    protected Component getCurrentLine(byte data) {
        TextComponent.Builder line = TextComponent.builder();
        line.append("[", TextColor.YELLOW);
        TextComponent.Builder colorBuilder = TextComponent.builder();
        if (data > 8) {
            line.color(TextColor.GREEN);
        } else {
            line.color(TextColor.DARK_RED);
        }
        for (int i = 0; i < data; ++i) {
            colorBuilder.append("|");
        }
        line.append((Component)colorBuilder.build());
        if (data < 15) {
            TextComponent.Builder blackBuilder = TextComponent.builder();
            blackBuilder.color(TextColor.BLACK);
            for (int i = data; i < 15; ++i) {
                blackBuilder.append("|");
            }
            line.append((Component)blackBuilder.build());
        }
        line.append("]", TextColor.YELLOW);
        return line.build();
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("item", "The item for the lightstone tool.");
        this.item = ItemParser.getItem(config.getString("item", ItemTypes.GLOWSTONE_DUST.id())).getType();
        config.setComment("use-action-bar", "Whether to use the action bar or the player's chat.");
        this.actionBar = config.getBoolean("use-action-bar", true);
    }
}

