/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics;

import com.sk89q.util.yaml.YAMLProcessor;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.jspecify.annotations.Nullable;

public abstract class Elevator
extends AbstractCraftBookMechanic {
    protected boolean elevatorAllowRedstone;
    protected int elevatorRedstoneRadius;
    protected boolean elevatorButtonEnabled;
    protected boolean elevatorLoop;

    public Elevator(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("allow-redstone", "Allows elevators to be triggered by redstone, which will move all players in a radius.");
        this.elevatorAllowRedstone = config.getBoolean("allow-redstone", false);
        config.setComment("redstone-player-search-radius", "The radius that elevators will look for players in when triggered by redstone.");
        this.elevatorRedstoneRadius = config.getInt("redstone-player-search-radius", 3);
        config.setComment("enable-buttons", "Allow elevators to be used by a button on the other side of the block.");
        this.elevatorButtonEnabled = config.getBoolean("enable-buttons", true);
        config.setComment("allow-looping", "Allows elevators to loop the world height. The heighest lift up will go to the next lift on the bottom of the world and vice versa.");
        this.elevatorLoop = config.getBoolean("allow-looping", false);
    }

    protected static enum LiftType {
        UP("[Lift Up]"),
        DOWN("[Lift Down]"),
        BOTH("[Lift UpDown]"),
        RECV("[Lift]");

        private final String label;

        private LiftType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static @Nullable LiftType fromLabel(String label) {
            for (LiftType liftType : LiftType.values()) {
                if (!liftType.label.equalsIgnoreCase(label)) continue;
                return liftType;
            }
            return null;
        }
    }
}

