/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockCategories;
import java.util.List;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.util.BlockParser;
import org.enginehub.craftbook.util.ConfigUtil;
import org.enginehub.craftbook.util.TernaryState;

public abstract class Chairs
extends AbstractCraftBookMechanic {
    protected static final double ARMOR_STAND_MOUNT_Y = 2.375;
    protected boolean allowHeldBlock;
    protected TernaryState allowSneaking;
    protected boolean regenHealth;
    protected boolean lowerExhaustion;
    protected double healAmount;
    protected List<BaseBlock> allowedBlocks;
    protected boolean faceWhenPossible;
    protected boolean requireSign;
    protected boolean exitToLastPosition;
    protected int maxSignDistance;
    protected int maxClickRadius;

    public Chairs(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("allow-holding-blocks", "Allow players to sit in chairs when holding blocks.");
        this.allowHeldBlock = config.getBoolean("allow-holding-blocks", false);
        config.setComment("allow-sneaking", "Allow players to sit in chairs while sneaking.");
        this.allowSneaking = TernaryState.parseTernaryState(config.getString("allow-sneaking", TernaryState.FALSE.toString()));
        config.setComment("regen-health", "Regenerate health passively when seated.");
        this.regenHealth = config.getBoolean("regen-health", true);
        config.setComment("lower-exhaustion", "Lower the player's exhaustion level when seated.");
        this.lowerExhaustion = config.getBoolean("lower-exhaustion", true);
        config.setComment("regen-health-amount", "The amount of health regenerated passively. (Can be decimal)");
        this.healAmount = config.getDouble("regen-health-amount", 1.0);
        config.setComment("blocks", "A list of blocks that can be sat on.");
        this.allowedBlocks = BlockParser.getBlocks(config.getStringList("blocks", ConfigUtil.getIdsFromCategory(BlockCategories.STAIRS)), true);
        config.setComment("face-correct-direction", "When the player sits, automatically face them the direction of the chair. (If possible)");
        this.faceWhenPossible = config.getBoolean("face-correct-direction", true);
        config.setComment("require-sign", "Require a sign to be attached to the chair in order to work!");
        this.requireSign = config.getBoolean("require-sign", false);
        config.setComment("max-sign-distance", "The maximum distance between the click point and the sign. (When require sign is on)");
        this.maxSignDistance = config.getInt("max-sign-distance", 3);
        config.setComment("max-click-radius", "The maximum distance the player can be from the sign.");
        this.maxClickRadius = config.getInt("max-click-radius", 5);
        config.setComment("exit-to-last-position", "Teleport players to their last position when they exit the chair.");
        this.exitToLastPosition = config.getBoolean("exit-to-last-position", false);
    }
}

