/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;

public abstract class BetterSponge
extends AbstractCraftBookMechanic {
    protected int radius;
    protected boolean sphereRange;
    protected boolean redstone;
    protected boolean includeWet;
    protected boolean destructive;

    public BetterSponge(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    protected boolean isValidSponge(BlockType type) {
        return type == BlockTypes.SPONGE || this.includeWet && type == BlockTypes.WET_SPONGE;
    }

    protected boolean isRemovableWater(BlockType material) {
        return material == BlockTypes.WATER || this.destructive && (material == BlockTypes.SEAGRASS || material == BlockTypes.TALL_SEAGRASS || material == BlockTypes.KELP_PLANT || material == BlockTypes.KELP);
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("radius", "The maximum radius of the sponge.");
        this.radius = config.getInt("radius", 5);
        config.setComment("sphere-range", "Whether the active range should be spherical or cuboid.");
        this.sphereRange = config.getBoolean("sphere-range", true);
        config.setComment("include-wet-sponges", "Whether wet sponges also activate the mechanic.");
        this.includeWet = config.getBoolean("include-wet-sponges", false);
        config.setComment("require-redstone", "Whether to require redstone to suck up water or not.");
        this.redstone = config.getBoolean("require-redstone", false);
        config.setComment("destructive", "Whether to remove blocks that spread water such as kelp. These will not be returned when the sponge is de-activated.");
        this.destructive = config.getBoolean("destructive", true);
    }
}

