/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.world.entity.EntityTypes;
import java.util.List;
import java.util.Set;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;

public abstract class BetterLeads
extends AbstractCraftBookMechanic {
    protected static final int MAX_LEASH_DISTANCE = 10;
    protected boolean stopTargetting;
    protected boolean ownerBreakOnly;
    protected boolean persistentHitch;
    protected boolean mobRepellant;
    protected Set<String> allowedMobs;

    public BetterLeads(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("stop-mob-target", "Stop hostile mobs targeting you if you are holding them on a leash.");
        this.stopTargetting = config.getBoolean("stop-mob-target", false);
        config.setComment("owner-unleash-only", "Only allow the owner of tameable entities to unleash them from a leash hitch.");
        this.ownerBreakOnly = config.getBoolean("owner-unleash-only", false);
        config.setComment("hitch-persists", "Stop leash hitches breaking when no entities are attached. This allows for a public horse hitch or similar.");
        this.persistentHitch = config.getBoolean("hitch-persists", false);
        config.setComment("mob-repel", "If you have a mob tethered to you, mobs of that type will not target you.");
        this.mobRepellant = config.getBoolean("mob-repel", false);
        config.setComment("allowed-mobs", "The list of mobs that can be tethered with a lead.");
        this.allowedMobs = Set.copyOf(config.getStringList("allowed-mobs", List.of(EntityTypes.ZOMBIE.id(), EntityTypes.SPIDER.id())));
    }
}

