/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanic.load;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanic.load.LoadDependency;

public class PluginDependency
implements LoadDependency {
    private final String pluginName;
    private final boolean optional;

    public PluginDependency(String pluginName) {
        this(pluginName, false);
    }

    public PluginDependency(String pluginName, boolean optional) {
        Preconditions.checkNotNull((Object)pluginName);
        this.pluginName = pluginName;
        this.optional = optional;
    }

    @Override
    public String getDependencyId() {
        return this.pluginName;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isMet() {
        return CraftBook.getInstance().getPlatform().isPluginAvailable(this.pluginName);
    }

    @Override
    public Component getFailureMessage() {
        return TranslatableComponent.of((String)"craftbook.mechanisms.plugin-required", (Component[])new Component[]{TextComponent.of((String)this.getDependencyId(), (TextColor)TextColor.WHITE)});
    }
}

