/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanic.load;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.load.LoadDependency;

public class MechanicDependency
implements LoadDependency {
    private final MechanicType<?> mechanicType;
    private final boolean optional;

    public MechanicDependency(MechanicType<?> mechanicType) {
        this(mechanicType, false);
    }

    public MechanicDependency(MechanicType<?> mechanicType, boolean optional) {
        Preconditions.checkNotNull(mechanicType);
        this.mechanicType = mechanicType;
        this.optional = optional;
    }

    public MechanicType<?> getMechanicType() {
        return this.mechanicType;
    }

    @Override
    public String getDependencyId() {
        return this.mechanicType.id();
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isMet() {
        return CraftBook.getInstance().getPlatform().getMechanicManager().isMechanicEnabled(this.mechanicType);
    }

    @Override
    public Component getFailureMessage() {
        return TranslatableComponent.of((String)"craftbook.mechanisms.mechanic-required", (Component[])new Component[]{TextComponent.of((String)this.mechanicType.getName(), (TextColor)TextColor.WHITE)});
    }
}

