/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanic;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.registry.Registry;
import com.sk89q.worldedit.util.formatting.text.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicCategory;
import org.enginehub.craftbook.mechanic.load.LoadDependency;
import org.enginehub.craftbook.mechanic.load.LoadPriority;
import org.jspecify.annotations.Nullable;

public class MechanicType<T extends CraftBookMechanic>
implements Keyed {
    public static final Registry<MechanicType<? extends CraftBookMechanic>> REGISTRY = new Registry("mechanic type", "craftbook:mechanic_type");
    private final String id;
    private final String name;
    private final String className;
    private final @Nullable Component description;
    private final MechanicCategory category;
    private final LoadPriority loadPriority;
    private final List<LoadDependency> dependencies;

    private MechanicType(String id, String name, @Nullable Component description, String className, MechanicCategory category, LoadPriority loadPriority, List<LoadDependency> dependencies) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.description = description;
        this.className = (String)Preconditions.checkNotNull((Object)className);
        this.category = (MechanicCategory)((Object)Preconditions.checkNotNull((Object)((Object)category)));
        this.loadPriority = (LoadPriority)((Object)Preconditions.checkNotNull((Object)((Object)loadPriority)));
        this.dependencies = List.copyOf((Collection)Preconditions.checkNotNull(dependencies));
    }

    public String id() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable Component getDescription() {
        return this.description;
    }

    public Class<T> getMechanicClass() throws ReflectiveOperationException {
        return Class.forName(this.className);
    }

    public MechanicCategory getCategory() {
        return this.category;
    }

    public LoadPriority getLoadPriority() {
        return this.loadPriority;
    }

    public List<LoadDependency> getDependencies() {
        return this.dependencies;
    }

    public boolean isInstance(CraftBookMechanic mechanic) {
        return mechanic.getMechanicType().id.equals(this.id);
    }

    public static class Builder<T extends CraftBookMechanic> {
        private @Nullable String id;
        private @Nullable String name;
        private @Nullable Component description;
        private @Nullable String className;
        private @Nullable MechanicCategory mechanicCategory;
        private LoadPriority loadPriority = LoadPriority.NORMAL;
        private final List<LoadDependency> dependencies = new ArrayList<LoadDependency>();

        public Builder<T> id(String id) {
            this.id = id;
            return this;
        }

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> description(Component description) {
            this.description = description;
            return this;
        }

        public Builder<T> className(String className) {
            this.className = className;
            return this;
        }

        public Builder<T> category(MechanicCategory mechanicCategory) {
            this.mechanicCategory = mechanicCategory;
            return this;
        }

        public Builder<T> loadPriority(LoadPriority loadPriority) {
            this.loadPriority = loadPriority;
            return this;
        }

        public Builder<T> dependsOn(LoadDependency loadDependency) {
            this.dependencies.add(loadDependency);
            return this;
        }

        public MechanicType<T> buildAndRegister() {
            Preconditions.checkNotNull((Object)this.id, (Object)"ID must be provided");
            Preconditions.checkNotNull((Object)this.name, (Object)"Name must be provided");
            Preconditions.checkNotNull((Object)this.className, (Object)"Class name must be provided");
            Preconditions.checkNotNull((Object)((Object)this.mechanicCategory), (Object)"Mechanic category must be provided");
            MechanicType mechanicType = new MechanicType(this.id, this.name, this.description, this.className, this.mechanicCategory, this.loadPriority, this.dependencies);
            REGISTRY.register(this.id, mechanicType);
            return mechanicType;
        }

        public static <T extends CraftBookMechanic> Builder<T> create() {
            return new Builder<T>();
        }
    }
}

