/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanic;

import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.exception.CraftBookException;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.exception.MechanicInitializationException;
import org.enginehub.craftbook.mechanic.load.LoadComparator;
import org.enginehub.craftbook.mechanic.load.LoadDependency;
import org.enginehub.craftbook.mechanic.load.MechanicDependency;
import org.enginehub.craftbook.mechanic.load.UnsatisfiedLoadDependencyException;
import org.jspecify.annotations.Nullable;

public abstract class MechanicManager {
    private final List<CraftBookMechanic> loadedMechanics = new ArrayList<CraftBookMechanic>();

    public abstract void setup();

    public void shutdown() {
        List.copyOf(this.loadedMechanics).forEach(this::disableMechanic);
        this.loadedMechanics.clear();
    }

    public List<CraftBookMechanic> getLoadedMechanics() {
        return List.copyOf(this.loadedMechanics);
    }

    public <T extends CraftBookMechanic> @Nullable MechanicType<T> getMechanicType(T mechanic) {
        for (MechanicType type : MechanicType.REGISTRY.values()) {
            if (!type.isInstance(mechanic)) continue;
            return type;
        }
        return null;
    }

    public <T extends CraftBookMechanic> Optional<T> getMechanic(@Nullable MechanicType<T> mechanicType) {
        if (mechanicType == null) {
            return Optional.empty();
        }
        for (CraftBookMechanic loadedMechanic : this.loadedMechanics) {
            if (!mechanicType.isInstance(loadedMechanic)) continue;
            return Optional.of(loadedMechanic);
        }
        return Optional.empty();
    }

    public void enableMechanics() {
        ArrayList mechanicTypes = new ArrayList(MechanicType.REGISTRY.values());
        mechanicTypes.sort(new LoadComparator());
        for (MechanicType mechanicType : mechanicTypes) {
            if (!CraftBook.getInstance().getPlatform().getConfiguration().enabledMechanics.contains(mechanicType.id())) continue;
            try {
                this.enableMechanic(mechanicType);
            }
            catch (UnsatisfiedLoadDependencyException e) {
                CraftBook.LOGGER.warn("Failed to load mechanic: " + e.getMechanicType().getName() + ". " + e.getMessage());
            }
            catch (MechanicInitializationException e) {
                CraftBook.LOGGER.warn("Failed to load mechanic: " + e.getMechanicType().id() + ". " + e.getMessage());
                if (e.getCause() == null) continue;
                e.getCause().printStackTrace();
            }
        }
    }

    public boolean isMechanicEnabled(@Nullable MechanicType<?> mechanicType) {
        return this.getMechanic(mechanicType).isPresent();
    }

    public void enableMechanic(MechanicType<?> mechanicType) throws MechanicInitializationException {
        if (this.isMechanicEnabled(mechanicType)) {
            throw new MechanicInitializationException(mechanicType, (Component)TranslatableComponent.of((String)"craftbook.mechanisms.already-enabled", (Component[])new Component[]{TextComponent.of((String)mechanicType.id())}));
        }
        try {
            CraftBookMechanic mech;
            for (LoadDependency dependency : mechanicType.getDependencies()) {
                if (dependency.isMet() || dependency.isOptional()) continue;
                throw new UnsatisfiedLoadDependencyException(mechanicType, dependency);
            }
            try {
                mech = (CraftBookMechanic)mechanicType.getMechanicClass().getDeclaredConstructor(MechanicType.class).newInstance(mechanicType);
            }
            catch (NoSuchMethodException e) {
                mech = (CraftBookMechanic)mechanicType.getMechanicClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            mech.loadConfiguration(CraftBook.getInstance().getPlatform().getWorkingDirectory().resolve("mechanics").resolve(mechanicType.getName() + ".yml"));
            mech.enable();
            this.loadedMechanics.add(mech);
            this.enableMechanicPlatformListeners(mech);
        }
        catch (CraftBookException e) {
            throw new MechanicInitializationException(mechanicType, (Component)TranslatableComponent.of((String)"craftbook.mechanisms.enable-failed", (Component[])new Component[]{TextComponent.of((String)mechanicType.getName(), (TextColor)TextColor.WHITE), e.getRichMessage()}), e);
        }
        catch (Throwable t) {
            throw new MechanicInitializationException(mechanicType, (Component)TranslatableComponent.of((String)"craftbook.mechanisms.enable-failed", (Component[])new Component[]{TextComponent.of((String)mechanicType.getName(), (TextColor)TextColor.WHITE), t.getMessage() != null ? TextComponent.of((String)t.getMessage()) : TextComponent.empty()}), t);
        }
    }

    protected abstract void enableMechanicPlatformListeners(CraftBookMechanic var1);

    public boolean disableMechanic(@Nullable CraftBookMechanic mechanic) {
        if (mechanic == null) {
            return false;
        }
        MechanicType<CraftBookMechanic> mechanicType = this.getMechanicType(mechanic);
        block0: for (CraftBookMechanic enabledMechanic : this.getLoadedMechanics()) {
            for (LoadDependency dependency : this.getMechanicType(enabledMechanic).getDependencies()) {
                MechanicDependency mechanicDependency;
                if (!(dependency instanceof MechanicDependency) || (mechanicDependency = (MechanicDependency)dependency).getMechanicType() != mechanicType) continue;
                this.disableMechanic(enabledMechanic);
                continue block0;
            }
        }
        mechanic.disable();
        this.loadedMechanics.remove(mechanic);
        this.disableMechanicPlatformListeners(mechanic);
        return true;
    }

    protected abstract void disableMechanicPlatformListeners(CraftBookMechanic var1);

    public void reloadMechanic(CraftBookMechanic mechanic) throws MechanicInitializationException {
        MechanicType<? extends CraftBookMechanic> mechanicType = mechanic.getMechanicType();
        try {
            mechanic.loadConfiguration(CraftBook.getInstance().getPlatform().getWorkingDirectory().resolve("mechanics").resolve(mechanicType.getName() + ".yml"));
            mechanic.reload();
        }
        catch (MechanicInitializationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new MechanicInitializationException(mechanicType, (Component)TranslatableComponent.of((String)"craftbook.mechanisms.reload-failed", (Component[])new Component[]{TextComponent.of((String)mechanicType.id())}), t);
        }
    }
}

