/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanic;

import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.component.PaginationBox;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import java.util.Comparator;
import java.util.List;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanic.MechanicManager;
import org.enginehub.craftbook.mechanic.MechanicType;

public class MechanicListBox
extends PaginationBox {
    private static final List<MechanicType<?>> MECHANICS = MechanicType.REGISTRY.values().stream().sorted(Comparator.comparing(MechanicType::id)).toList();
    private final Actor actor;

    public MechanicListBox(Actor actor) {
        super("Mechanics", MechanicListBox.getCommandPrefix() + "mech list -p %page%");
        this.actor = actor;
    }

    public Component getComponent(int number) {
        MechanicType<?> mechanic = MECHANICS.get(number);
        MechanicManager manager = CraftBook.getInstance().getPlatform().getMechanicManager();
        boolean isEnabled = manager.isMechanicEnabled(mechanic);
        TextComponent mechanicName = TextComponent.of((String)mechanic.getName(), (TextColor)TextColor.WHITE);
        if (mechanic.getDescription() != null && this.actor.isPlayer()) {
            mechanicName = (TextComponent)mechanicName.hoverEvent(HoverEvent.showText((Component)mechanic.getDescription()));
        }
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().append((Component)TextComponent.of((String)"\u2588", (TextColor)(isEnabled ? TextColor.GREEN : TextColor.RED)))).append((Component)TextComponent.space())).append((Component)mechanicName)).append((Component)TextComponent.space());
        if (this.actor.isPlayer()) {
            TextComponent modifyComponent = isEnabled ? (TextComponent)((TextComponent)TextComponent.of((String)"[Disable]", (TextColor)TextColor.RED).hoverEvent(HoverEvent.showText((Component)TranslatableComponent.of((String)"craftbook.mechanisms.click-to-disable")))).clickEvent(ClickEvent.runCommand((String)(MechanicListBox.getCommandPrefix() + "mech disable " + mechanic.id() + " -l " + this.getCurrentPage()))) : (TextComponent)((TextComponent)TextComponent.of((String)"[Enable]", (TextColor)TextColor.GREEN).hoverEvent(HoverEvent.showText((Component)TranslatableComponent.of((String)"craftbook.mechanisms.click-to-enable")))).clickEvent(ClickEvent.runCommand((String)(MechanicListBox.getCommandPrefix() + "mech enable " + mechanic.id() + " -l " + this.getCurrentPage())));
            int length = FontInfo.getPxLength(mechanic.getName());
            int leftover = 200 - length - 4;
            if (leftover > 0) {
                builder.append((Component)TextComponent.of((String)".".repeat(leftover / 2), (TextColor)TextColor.DARK_GRAY));
            }
            ((TextComponent.Builder)builder.append((Component)TextComponent.space())).append((Component)modifyComponent);
        }
        return builder.build();
    }

    private static String getCommandPrefix() {
        return "/craftbook5:craftbook ";
    }

    public int getComponentsSize() {
        return MECHANICS.size();
    }

    private static final class FontInfo {
        private FontInfo() {
        }

        static int getPxLength(char c) {
            return switch (c) {
                case ':', 'i' -> 1;
                case 'l' -> 2;
                case '*', 't' -> 3;
                case 'f', 'k' -> 4;
                default -> 5;
            };
        }

        static int getPxLength(String string) {
            return string.chars().reduce(0, (p, i) -> p + FontInfo.getPxLength((char)i) + 1);
        }
    }
}

